/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.cluster;

import java.util.concurrent.CountDownLatch;
import org.jupiter.example.cluster.service.ClusterFailServiceImpl;
import org.jupiter.example.cluster.service.ClusterSuccessServiceImpl;
import org.jupiter.rpc.DefaultServer;
import org.jupiter.rpc.JServer;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.ProviderInterceptor;
import org.jupiter.transport.JAcceptor;
import org.jupiter.transport.netty.JNettyTcpAcceptor;

public class JupiterClusterServer {
    public static void main(String[] args) {
        JServer[] servers = new JServer[]{new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18090)), new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18091)), new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18092)), new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18093)), new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18094))};
        final CountDownLatch latch = new CountDownLatch(servers.length);
        int i = 0;
        while (i < servers.length) {
            final JServer server = servers[i];
            final int index = i++;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        JServer.ServiceRegistry registry = server.serviceRegistry();
                        ServiceWrapper provider = index > 3 ? registry.provider((Object)new ClusterSuccessServiceImpl(), new ProviderInterceptor[0]).register() : registry.provider((Object)new ClusterFailServiceImpl(), new ProviderInterceptor[0]).register();
                        server.connectToRegistryServer("127.0.0.1:20001");
                        server.publish(provider);
                        server.start();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

