/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.cluster.failover;

import org.jupiter.example.cluster.service.ClusterService;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFutureContext;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.exception.ConnectFailedException;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class FailOverJupiterClient {
    public static void main(String[] args) {
        JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector());
        client.connectToRegistryServer("127.0.0.1:20001");
        JConnector.ConnectionWatcher watcher = client.watchConnections(ClusterService.class, "1.0.0");
        if (!watcher.waitForAvailable(3000L)) {
            throw new ConnectFailedException();
        }
        System.err.println("\u540c\u6b65\u8c03\u7528failover\u6d4b\u8bd5...........");
        ClusterService syncService = (ClusterService)ProxyFactory.factory(ClusterService.class).version("1.0.0").client(client).invokeType(InvokeType.SYNC).clusterStrategy(ClusterInvoker.Strategy.FAIL_OVER).failoverRetries(5).newProxyInstance();
        try {
            System.err.println("Sync result=" + syncService.helloString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("\u5f02\u6b65\u8c03\u7528failover\u6d4b\u8bd5...........");
        ClusterService asyncService = (ClusterService)ProxyFactory.factory(ClusterService.class).version("1.0.0").client(client).invokeType(InvokeType.ASYNC).clusterStrategy(ClusterInvoker.Strategy.FAIL_OVER).failoverRetries(5).newProxyInstance();
        try {
            System.out.println(asyncService.helloInt());
            InvokeFuture future = InvokeFutureContext.future(Integer.TYPE);
            future.addListener((JListener)new JListener<Integer>(){

                public void complete(Integer result) {
                    System.err.println("Async result=" + result);
                }

                public void failure(Throwable cause) {
                    cause.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

