/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.exception;

import org.jupiter.example.ExceptionServiceTest;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.exception.ConnectFailedException;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class JupiterClient {
    public static void main(String[] args) {
        final JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector());
        client.connectToRegistryServer("127.0.0.1:20001");
        JConnector.ConnectionWatcher watcher = client.watchConnections(ExceptionServiceTest.class, "1.0.0.daily");
        if (!watcher.waitForAvailable(3000L)) {
            throw new ConnectFailedException();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                client.shutdownGracefully();
            }
        });
        ExceptionServiceTest service = (ExceptionServiceTest)ProxyFactory.factory(ExceptionServiceTest.class).version("1.0.0.daily").client(client).serializerType(SerializerType.PROTO_STUFF).failoverRetries(5).newProxyInstance();
        try {
            service.hello(1);
        }
        catch (Exception e) {
            System.err.println("remote stack trace =========================");
            e.printStackTrace();
            System.err.println("=========================");
            System.err.println("expected message: " + e.getMessage());
        }
        try {
            service.hello(0);
        }
        catch (Exception e) {
            System.err.println("local stack trace =========================");
            e.printStackTrace();
            System.err.println("=========================");
            System.err.println("unexpected message: " + e.getMessage());
        }
    }
}

