/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.flight.exec;

import java.util.List;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.example.flight.exec.UserExecImpl;
import org.jupiter.flight.exec.ExecResult;
import org.jupiter.flight.exec.JavaClassExec;
import org.jupiter.flight.exec.JavaCompiler;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.DispatchType;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.rpc.consumer.future.InvokeFutureContext;
import org.jupiter.rpc.consumer.future.InvokeFutureGroup;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.exception.ConnectFailedException;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class FlightExecJupiterClient {
    public static void main(String[] args) {
        JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector());
        client.connectToRegistryServer("127.0.0.1:20001");
        JConnector.ConnectionWatcher watcher = client.watchConnections(JavaClassExec.class);
        if (!watcher.waitForAvailable(3000L)) {
            throw new ConnectFailedException("waitForAvailable() timeout");
        }
        JavaClassExec service = (JavaClassExec)ProxyFactory.factory(JavaClassExec.class).version("1.0.0").client(client).dispatchType(DispatchType.BROADCAST).invokeType(InvokeType.ASYNC).newProxyInstance();
        try {
            byte[] classBytes = JavaCompiler.compile((String)(SystemPropertyUtil.get((String)"user.dir") + "/jupiter-example/src/main/java/"), (String)UserExecImpl.class.getName(), (List)Lists.newArrayList((Object[])new String[]{"-verbose", "-source", "1.7", "-target", "1.7"}));
            service.exec(classBytes);
            final InvokeFutureGroup future = InvokeFutureContext.futureBroadcast(ExecResult.class);
            future.addListener((JListener)new JListener<ExecResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(ExecResult result) {
                    InvokeFutureGroup invokeFutureGroup = future;
                    synchronized (invokeFutureGroup) {
                        System.out.println("= debug info ======================================");
                        System.out.println(result.getDebugInfo());
                        System.out.println("= return value ====================================");
                        System.out.println(result.getValue());
                        System.out.println();
                        System.out.println();
                    }
                }

                public void failure(Throwable cause) {
                    cause.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

