/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.flight.exec;

import java.util.concurrent.CountDownLatch;
import org.jupiter.flight.exec.JavaClassExecProvider;
import org.jupiter.rpc.DefaultServer;
import org.jupiter.rpc.JServer;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.ProviderInterceptor;
import org.jupiter.transport.JAcceptor;
import org.jupiter.transport.netty.JNettyTcpAcceptor;

public class FlightExecJupiterServer {
    private static JServer[] servers = new JServer[]{new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18090)), new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18091))};

    public static void main(String[] args) {
        final CountDownLatch latch = new CountDownLatch(servers.length);
        for (final JServer server : servers) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServiceWrapper service = server.serviceRegistry().provider((Object)new JavaClassExecProvider(), new ProviderInterceptor[0]).register();
                        server.connectToRegistryServer("127.0.0.1:20001");
                        server.publish(service);
                        server.start();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

