/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.round;

import org.jupiter.example.ServiceTest;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.JListener;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFutureContext;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.exception.ConnectFailedException;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class AsyncJupiterClient {
    public static void main(String[] args) {
        JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector());
        client.connectToRegistryServer("127.0.0.1:20001");
        JConnector.ConnectionWatcher watcher = client.watchConnections(ServiceTest.class, "1.0.0.daily");
        if (!watcher.waitForAvailable(3000L)) {
            throw new ConnectFailedException();
        }
        ServiceTest service = (ServiceTest)ProxyFactory.factory(ServiceTest.class).version("1.0.0.daily").client(client).invokeType(InvokeType.ASYNC).newProxyInstance();
        try {
            ServiceTest.ResultClass result = service.sayHello(new String[0]);
            System.out.println("sync result: " + result);
            InvokeFuture future = InvokeFutureContext.future(ServiceTest.ResultClass.class);
            future.addListener((JListener)new JListener<ServiceTest.ResultClass>(){

                public void complete(ServiceTest.ResultClass result) {
                    System.out.println("callback: " + result);
                }

                public void failure(Throwable cause) {
                    cause.printStackTrace();
                }
            });
            System.out.println("future.get: " + future.getResult());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

