/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.round;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.jupiter.example.ServiceTest2Impl;
import org.jupiter.example.ServiceTestImpl;
import org.jupiter.monitor.MonitorServer;
import org.jupiter.rpc.DefaultServer;
import org.jupiter.rpc.JRequest;
import org.jupiter.rpc.JServer;
import org.jupiter.rpc.flow.control.ControlResult;
import org.jupiter.rpc.flow.control.FlowController;
import org.jupiter.rpc.model.metadata.ServiceWrapper;
import org.jupiter.rpc.provider.ProviderInterceptor;
import org.jupiter.rpc.tracing.TraceId;
import org.jupiter.transport.JAcceptor;
import org.jupiter.transport.netty.JNettyTcpAcceptor;

public class JupiterServer {
    public static void main(String[] args) {
        final JServer server = new DefaultServer().withAcceptor((JAcceptor)new JNettyTcpAcceptor(18090));
        final MonitorServer monitor = new MonitorServer();
        try {
            monitor.start();
            server.withGlobalInterceptors(new ProviderInterceptor[]{new GlobalInterceptor()});
            ServiceTestImpl service = new ServiceTestImpl();
            ServiceWrapper provider1 = server.serviceRegistry().provider((Object)service, new ProviderInterceptor[]{new PrivateInterceptor()}).register();
            ServiceWrapper provider2 = server.serviceRegistry().provider((Object)new ServiceTest2Impl(), new ProviderInterceptor[0]).flowController((FlowController)new PrivateFlowController()).register();
            server.connectToRegistryServer("127.0.0.1:20001");
            server.publishWithInitializer(provider1, (JServer.ProviderInitializer)new JServer.ProviderInitializer<ServiceTestImpl>(){

                public void init(ServiceTestImpl provider) {
                    provider.setStrValue("provider1");
                    provider.setIntValue(111);
                }
            });
            server.publish(provider2);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    monitor.shutdownGracefully();
                    server.shutdownGracefully();
                }
            });
            server.start();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static class PrivateInterceptor
    implements ProviderInterceptor {
        PrivateInterceptor() {
        }

        public void beforeInvoke(TraceId traceId, Object provider, String methodName, Object[] args) {
            System.out.println("PrivateInterceptor before: " + provider + "#" + methodName + " args: " + Arrays.toString(args));
        }

        public void afterInvoke(TraceId traceId, Object provider, String methodName, Object[] args, Object result, Throwable failCause) {
            System.out.println("PrivateInterceptor after: " + provider + "#" + methodName + " args: " + Arrays.toString(args) + " result: " + result);
        }
    }

    static class GlobalInterceptor
    implements ProviderInterceptor {
        GlobalInterceptor() {
        }

        public void beforeInvoke(TraceId traceId, Object provider, String methodName, Object[] args) {
            System.out.println("GlobalInterceptor before: " + provider + "#" + methodName + " args: " + Arrays.toString(args));
        }

        public void afterInvoke(TraceId traceId, Object provider, String methodName, Object[] args, Object result, Throwable failCause) {
            System.out.println("GlobalInterceptor after: " + provider + "#" + methodName + " args: " + Arrays.toString(args) + " result: " + result);
        }
    }

    static class PrivateFlowController
    implements FlowController<JRequest> {
        private AtomicLong count = new AtomicLong();

        PrivateFlowController() {
        }

        public ControlResult flowControl(JRequest request) {
            if (this.count.getAndIncrement() > 9999L) {
                return new ControlResult(false, "fuck out!!!");
            }
            return ControlResult.ALLOWED;
        }
    }
}

