/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.example.round;

import org.jupiter.example.ServiceTest;
import org.jupiter.example.ServiceTest2;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.rpc.consumer.cluster.ClusterInvoker;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.exception.ConnectFailedException;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class SyncJupiterClient {
    public static void main(String[] args) {
        final JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector());
        client.connectToRegistryServer("127.0.0.1:20001");
        JConnector.ConnectionWatcher watcher1 = client.watchConnections(ServiceTest.class, "1.0.0.daily");
        JConnector.ConnectionWatcher watcher2 = client.watchConnections(ServiceTest2.class, "1.0.0.daily");
        if (!watcher1.waitForAvailable(3000L)) {
            throw new ConnectFailedException();
        }
        if (!watcher2.waitForAvailable(3000L)) {
            throw new ConnectFailedException();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                client.shutdownGracefully();
            }
        });
        ServiceTest service1 = (ServiceTest)ProxyFactory.factory(ServiceTest.class).version("1.0.0.daily").client(client).serializerType(SerializerType.JAVA).clusterStrategy(ClusterInvoker.Strategy.FAIL_OVER).failoverRetries(5).newProxyInstance();
        ServiceTest2 service2 = (ServiceTest2)ProxyFactory.factory(ServiceTest2.class).version("1.0.0.daily").client(client).newProxyInstance();
        try {
            ServiceTest.ResultClass result1 = service1.sayHello("jupiter", "hello");
            System.out.println(result1);
            String result2 = service2.sayHelloString();
            System.out.println(result2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

