/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import com.google.inject.Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.common.Tools;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.spi.guice.GuiceScoped;
import juzu.io.UndeclaredIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieScopeContext
implements ScopedContext {
    public static final int FLASH = 0;
    public static final int SESSION = 1;
    HashMap<String, Scoped> values;
    HashMap<String, String> snapshot;
    boolean purged;

    public Scoped get(Object key) throws NullPointerException {
        String name = this.nameOf(key);
        if (name != null) {
            String encoded;
            Scoped scoped = null;
            if (this.values != null) {
                scoped = this.values.get(name);
            }
            if (scoped == null && this.snapshot != null && (encoded = this.snapshot.get(name)) != null) {
                try {
                    byte[] bytes = DatatypeConverter.parseBase64Binary((String)encoded);
                    Object o = Tools.unserialize((ClassLoader)Thread.currentThread().getContextClassLoader(), Serializable.class, (InputStream)new ByteArrayInputStream(bytes));
                    if (this.values == null) {
                        this.values = new HashMap();
                    }
                    scoped = new GuiceScoped(o);
                    this.values.put(name, scoped);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return scoped;
        }
        return null;
    }

    public void set(Object key, Scoped scoped) throws NullPointerException {
        String name = this.nameOf(key);
        if (name == null) {
            throw new UndeclaredIOException((IOException)new NotSerializableException("Type should be named with @" + Named.class.getSimpleName()));
        }
        if (!(scoped.get() instanceof Serializable)) {
            throw new UndeclaredIOException((IOException)new NotSerializableException("Could not serialize object"));
        }
        if (this.values == null) {
            this.values = new HashMap();
        }
        if (this.snapshot == null) {
            this.snapshot = new HashMap();
        }
        this.values.put(name, scoped);
        if (!this.snapshot.containsKey(name)) {
            this.snapshot.put(name, this.encode((Serializable)scoped.get()));
        }
    }

    String encode(Serializable o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tools.serialize((Serializable)o, (OutputStream)baos);
            baos.close();
            return DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize object " + o);
        }
    }

    private String nameOf(Object key) {
        Key gkey = (Key)key;
        Class type = gkey.getTypeLiteral().getRawType();
        Named name = type.getAnnotation(Named.class);
        return name != null ? name.value() : null;
    }

    public int size() {
        return this.getNames().size();
    }

    Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.values != null) {
            names.addAll(this.values.keySet());
        }
        if (this.snapshot != null) {
            names.addAll(this.snapshot.keySet());
        }
        return names;
    }

    public void close() {
        this.purged = true;
    }

    public Iterator<Scoped> iterator() {
        return Tools.emptyIterator();
    }
}

