/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="Match")
public class Match
implements Serializable {
    private static final long serialVersionUID = -3682911278800228726L;
    static Logger log = LoggerFactory.getLogger(Match.class);
    public static final Set<String> NUMERIC_FIELDS = new HashSet<String>();
    @XStreamAsAttribute
    protected String op = Operator.EQ.toString();
    @XStreamAlias(value="Variable")
    protected String variable;
    @XStreamImplicit(itemFieldName="Value")
    protected TreeSet<String> values = new TreeSet();
    protected Operator operator;
    protected Condition condition;

    protected Match() {
    }

    public Match(String variable) {
        this.variable = variable;
        this.values = new TreeSet();
    }

    public Match(String variable, String value) {
        this(variable, Operator.EQ, value);
    }

    public Match(String variable, Operator op, String value) {
        this.variable = variable;
        this.values.add(value);
        this.op = op.toString();
    }

    public String getOperator() {
        return this.op;
    }

    public void setOperator(String op) {
        this.op = op;
    }

    public Operator getOp() {
        if (this.operator == null) {
            try {
                this.operator = Operator.read(this.op);
            }
            catch (Exception e) {
                this.operator = Operator.EQ;
            }
        }
        return this.operator;
    }

    public String getVariable() {
        if (this.variable == null) {
            return null;
        }
        return this.variable.toUpperCase();
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    public Object getValueObject() {
        if (this.getValue().toString().matches("-?\\d+") && (this.getVariable().equals("SEVERITY") || this.getVariable().equals("RULE_SEV"))) {
            return new Integer(this.getValue().toString());
        }
        return this.getValue();
    }

    public void setValue(String val) {
        this.values.clear();
        this.values.add(val);
    }

    public String toXML() {
        return AuditEventFilter.getXStream().toXML((Object)this);
    }

    public String toString() {
        return "[[" + this.getVariable().toLowerCase() + " " + this.op + " " + this.getValue() + " ]]";
    }
}

