/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.script;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jwall.audit.EventView;
import org.jwall.audit.script.ScriptEventView;
import org.jwall.log.LogMessage;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptRunner {
    public static final String[] RESERVED_VARIABLES = new String[]{"events", "logs", "result"};
    static Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    String lang;
    String script;
    URL scriptUrl;
    Map<String, Object> results = new LinkedHashMap<String, Object>();
    transient Writer outputWriter;
    transient Reader scriptReader;
    transient Writer errorWriter;
    transient ScriptEngine engine;
    final Map<String, Object> bindings = new LinkedHashMap<String, Object>();
    final ScriptContext context;

    public ScriptRunner(String scriptLanguage) throws Exception {
        this.lang = scriptLanguage;
        log.debug("Creating script-engine for script-language {}", (Object)this.lang);
        long t0 = System.currentTimeMillis();
        ScriptEngineManager manager = new ScriptEngineManager();
        long t1 = System.currentTimeMillis();
        log.debug("Start of script-engine manager required {} ms", (Object)(t1 - t0));
        log.debug("Creating script-engine by name '{}'", (Object)this.lang);
        t0 = System.currentTimeMillis();
        List<ScriptEngineFactory> factories = manager.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            log.debug("ScriptEngineFactory");
            log.debug("   language name = {}", (Object)factory.getLanguageName());
            log.debug("   language version = {}", (Object)factory.getLanguageVersion());
            log.debug("   engine extensions = {}", factory.getExtensions());
        }
        this.engine = manager.getEngineByName(this.lang);
        t1 = System.currentTimeMillis();
        log.debug("start of script-engine required {}ms", (Object)(t1 - t0));
        this.context = this.engine.getContext();
    }

    public ScriptRunner(URL scriptUrl, String scriptLanguage) throws Exception {
        this(scriptLanguage);
        this.script = null;
        this.scriptUrl = scriptUrl;
        this.lang = scriptLanguage;
    }

    public ScriptRunner(String scriptSource, String scriptLanguage) throws Exception {
        this(scriptLanguage);
        this.script = scriptSource;
        this.scriptUrl = null;
        this.lang = scriptLanguage;
    }

    public void init(OutputStream out, OutputStream err) throws Exception {
        this.outputWriter = new PrintWriter(out);
        log.debug("Initializing script-execution");
        if (this.scriptUrl != null) {
            log.debug("Reading script from script-url: {}", (Object)this.scriptUrl);
            this.scriptReader = new InputStreamReader(this.scriptUrl.openStream());
        } else {
            log.debug("Reading script from provided string-source\n{}", (Object)this.script);
            this.scriptReader = new StringReader(this.script);
        }
        if (out != null) {
            this.errorWriter = new OutputStreamWriter(out);
        }
    }

    public void setErrorWriter(Writer out) {
        if (out != null) {
            this.errorWriter = out;
        }
    }

    public void setOutputWriter(Writer out) {
        this.outputWriter = out;
    }

    public void bind(String key, Object val) throws Exception {
        if (ScriptRunner.isReservedVariable(key)) {
            throw new Exception("Variable '" + key + "' is matching a reserved key-word!");
        }
        this.bindings.put(key, val);
    }

    public void setAuditEventView(EventView<AuditEvent> view) {
        this.bindings.put("events", new ScriptEventView<AuditEvent>("", view));
        log.debug("updated bindings: {}", this.bindings);
    }

    public void setLogMessageView(EventView<LogMessage> view) {
        this.bindings.put("logs", view);
        log.debug("updated bindings: {}", this.bindings);
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    public void execute() throws Exception {
        if (this.context == null) {
            throw new Exception("ScriptRunner not initialied!");
        }
        log.debug("Script is read from {}", (Object)this.scriptReader);
        if (this.script != null) {
            log.debug("Script-source is:\n{}", (Object)this.script);
        }
        log.debug("Setting output-writer to {}", (Object)this.outputWriter);
        this.context.setWriter(this.outputWriter);
        if (this.errorWriter != null) {
            log.debug("Setting error-output to {}", (Object)this.errorWriter);
            this.context.setErrorWriter(this.errorWriter);
        }
        log.debug("Bindings: {}", this.bindings);
        for (String key : this.bindings.keySet()) {
            log.debug("binding variable {} to {}", (Object)key, this.bindings.get(key));
            this.context.setAttribute(key, this.bindings.get(key), 100);
        }
        log.debug("Binding 'result' map (String -> Object)");
        this.context.setAttribute("result", this.results, 100);
        log.debug("Evaluating script...");
        Object result = this.engine.eval(this.scriptReader);
        log.debug("Script has been executed, result object is: {}", result);
        log.debug("  result map is: {}", this.results);
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public static final boolean isReservedVariable(String variable) {
        for (String var : RESERVED_VARIABLES) {
            if (!var.equalsIgnoreCase(variable)) continue;
            return true;
        }
        return false;
    }
}

