/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.server;

import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.jwall.audit.server.ModSecurity2AuditStream;
import org.jwall.audit.server.SyslogReceiver;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.AuditEventWriter;
import org.jwall.web.audit.io.ModSecurity2AuditWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventStreamHandler
extends Thread
implements AuditEventListener {
    static Logger log = LoggerFactory.getLogger(AuditEventStreamHandler.class);
    Long start;
    Integer count = 0;
    Socket socket;
    AuditEventWriter writer;
    static final DecimalFormat fmt = new DecimalFormat("0.00");
    AuditEventListener store = null;
    SyslogReceiver parent;
    boolean gzip = false;

    public AuditEventStreamHandler(SyslogReceiver parent, Socket socket, boolean gzip) throws Exception {
        this.parent = parent;
        this.socket = socket;
        this.gzip = gzip;
        File outFile = new File(File.separator + "tmp" + File.separator + socket.getInetAddress().getHostAddress() + "-" + socket.getPort() + "-audit.log");
        System.out.println("Writing to " + outFile.getAbsolutePath());
        this.writer = new ModSecurity2AuditWriter(outFile);
    }

    public void setEventStore(AuditEventListener store) {
        this.store = store;
    }

    @Override
    public void run() {
        try {
            this.start = System.currentTimeMillis();
            InputStream in = null;
            in = this.gzip ? new GZIPInputStream(this.socket.getInputStream()) : this.socket.getInputStream();
            ModSecurity2AuditStream reader = new ModSecurity2AuditStream(in, this);
            AuditEvent evt = reader.readNext();
            while (evt != null && !this.socket.isClosed()) {
                this.eventArrived(evt);
                evt = reader.readNext();
            }
            System.out.println("Connection closed.");
        }
        catch (EOFException eof) {
            System.out.println("Connection closed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        try {
            if (this.store != null) {
                this.store.eventArrived(evt);
            }
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
            if (this.count % 1000 == 0) {
                Long time = System.currentTimeMillis() - this.start;
                log.info(this.count + " events received in " + (int)(time / 1000L) + " seconds (" + fmt.format(1000.0 * this.count.doubleValue() / time.doubleValue()) + " events/second)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent e : events) {
            this.eventArrived(e);
        }
    }
}

