/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jwall.log.io.MParser;
import org.jwall.log.io.Parser;
import org.jwall.log.io.ParserGenerator;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericParser
extends MParser
implements Parser<Map<String, String>> {
    static Logger log = LoggerFactory.getLogger(GenericParser.class);
    List<ParserGenerator.Token> tokens;
    Map<String, String> defaults = new LinkedHashMap<String, String>();

    public GenericParser(List<ParserGenerator.Token> token) {
        this.tokens = token;
    }

    @Override
    public Map<String, String> parse(String str) throws ParseException {
        this.reset();
        LinkedHashMap<String, String> reads = new LinkedHashMap<String, String>();
        reads.putAll(this.defaults);
        for (int i = 0; i < this.tokens.size(); ++i) {
            ParserGenerator.Token token = this.tokens.get(i);
            ParserGenerator.Token next = null;
            if (i + 1 < this.tokens.size()) {
                next = this.tokens.get(i + 1);
            }
            log.debug("Remainder string: '{}'", (Object)this.remainder(str));
            if (!token.isVariable()) {
                log.debug("Next token is a constant '{}'", (Object)token.getValue());
                int start = this.pos;
                if (token.isRegex()) {
                    int len = token.skipLength(this.remainder(str));
                    this.pos += len;
                    continue;
                }
                String val = this.prefix(str, token.getValue().length());
                log.debug("   const read: '{}'", (Object)val);
                if (!token.getValue().equals(val)) {
                    throw new ParseException("Failed to read '" + token.getValue() + "', found: " + val + " at position " + start);
                }
                this.pos += token.getValue().length();
                continue;
            }
            log.debug("Next token is a variable '{}'", (Object)token.getValue());
            String val = null;
            if (token.isRegex()) {
                String rem = this.remainder(str);
                int len = token.skipLength(rem);
                val = rem.substring(0, len);
                this.pos += len;
                reads.put(token.getName(), val);
                continue;
            }
            val = next != null && !next.isVariable() ? this.readTokenUntil(str, next.getValue()) : (next == null ? this.remainder(str) : this.readToken(str));
            if (log.isDebugEnabled()) {
                log.debug("   {} = '{}'", (Object)token.getValue(), (Object)val);
                log.debug("   {} = '{}'", (Object)this.strip(token.getValue()), (Object)val);
                log.debug("remainder: '{}'", (Object)this.remainder(str));
            }
            reads.put(this.strip(token.getValue()), val);
        }
        return reads;
    }

    public String strip(String name) {
        if (name.startsWith("%{") && name.endsWith("}")) {
            int len = name.length();
            return name.substring(2, len - 1);
        }
        return name;
    }

    @Override
    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
        this.defaults.clear();
        this.defaults.putAll(defaults);
    }
}

