/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventFactory;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuditEventFactory
implements AuditEventFactory {
    static Logger log = LoggerFactory.getLogger((String)"DefaultAuditEventFactory");
    protected static Long evtCount = 0L;
    private static AuditEventFactory sharedInstance = null;
    private static final String RULE_FILE_PREFIX = "[file ";
    private static final String RULE_LINE_PREFIX = "[line ";
    private static final String RULE_ID_PREFIX = "[id ";
    private static final String RULE_MSG_PREFIX = "[msg ";
    private static final String RULE_SEVERITY_PREFIX = "[severity ";
    private static final String RULE_TAG_PREFIX = "[tag ";
    private static final String[] extract = new String[]{"[file ", "RULE_FILE", "[line ", "RULE_LINE", "[id ", "RULE_ID", "[msg ", "RULE_MSG", "[tag ", "RULE_TAG", "[severity ", "RULE_SEV"};

    public DefaultAuditEventFactory() {
        evtCount = new Long(0L);
    }

    public static AuditEventFactory getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DefaultAuditEventFactory();
        }
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditEvent createAuditEvent(String[] sectionData, AuditEventType type) throws ParseException {
        ModSecurityAuditEvent evt = new ModSecurityAuditEvent(sectionData, type);
        if (evt != null) {
            Long l = evtCount;
            synchronized (l) {
                Long l2 = evtCount;
                Long l3 = evtCount = Long.valueOf(evtCount + 1L);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditEvent createAuditEvent(String id, String[] data, File inputFile, long offset, long size, AuditEventType type) throws ParseException {
        ModSecurityAuditEvent evt = new ModSecurityAuditEvent(id, data, inputFile, offset, size, type);
        if (evt != null) {
            Long l = evtCount;
            synchronized (l) {
                Long l2 = evtCount;
                Long l3 = evtCount = Long.valueOf(evtCount + 1L);
            }
        }
        if (inputFile != null) {
            evt.set("FILE", inputFile.getAbsolutePath());
        }
        evt.set("FILE_OFFSET", Long.toString(offset));
        evt.set("SIZE", Long.toString(size));
        return evt;
    }

    public static Map<String, List<String>> parseAuditTrailer(Map<String, List<String>> cols, String trailer) throws ParseException {
        if (trailer == null || "".equals(trailer.trim())) {
            return cols;
        }
        try {
            BufferedReader r = new BufferedReader(new StringReader(trailer));
            String line = r.readLine();
            while (line != null) {
                System.out.println("Processing tailer-line: " + line);
                int start = line.indexOf("[");
                if (start >= 0) {
                    String val = "";
                    int i = 0;
                    while (start >= 0 && i + 2 < extract.length) {
                        if ((line = line.substring(start)).startsWith(extract[i])) {
                            int end = line.indexOf("]");
                            val = line.substring(extract[i].length(), end).trim();
                            if (val.startsWith("\"")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("\"")) {
                                val = val.substring(0, val.length() - 1);
                            }
                            DefaultAuditEventFactory.addValue(cols, extract[i + 1], val);
                            start = line.indexOf("[", end);
                        } else {
                            ++start;
                        }
                        i += 2;
                    }
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException("Error while parsing the audit-trailer: " + e.getMessage());
        }
        return cols;
    }

    public static void addValue(Map<String, List<String>> cols, String col, String value) {
        log.info("Adding value \"" + value + "\" to variable \"" + col + "\"");
        List<String> collection = cols.get(col);
        if (collection == null) {
            collection = new LinkedList<String>();
            cols.put(col, collection);
        }
        collection.add(value);
    }

    public static Long getEventCount() {
        return evtCount;
    }
}

