/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.filter.Operator;

@XStreamAlias(value="DateMatch")
public class AuditEventDateMatch
extends AuditEventMatch {
    private static final long serialVersionUID = 8260257445184659695L;
    public static SimpleDateFormat FMT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    @XStreamAsAttribute
    String variable = "DATE";
    @XStreamAsAttribute
    Date date = new Date();

    public AuditEventDateMatch(Operator op, Date date) throws SyntaxException {
        super("DATE", op, FMT.format(date));
    }

    public AuditEventDateMatch(String var, Operator op, Date date) throws SyntaxException {
        super("DATE", op, FMT.format(date));
        this.date = date;
        if (!var.equals("DATE") && !var.equals("RECEIVED")) {
            throw new SyntaxException("Variable '" + this.variable + "' is not known to be a date-variable! Valid Variables are " + "DATE" + " and " + "RECEIVED");
        }
        this.variable = var;
    }

    public void setComparator(String compare) throws SyntaxException {
        if (!this.isValidOp(compare)) {
            throw new SyntaxException("Invalid comparator for match: '" + compare + "'!");
        }
        this.setOperator(compare);
    }

    public void setDate(Date val) {
        this.date = val;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public Date getValueObject() {
        return this.getDate();
    }

    public boolean isValidOp(String op) {
        return this.getSupportedOperators().contains(op);
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public boolean matches(AuditEvent evt) {
        Date evtDate = evt.getDate();
        Date date = new Date(0L);
        try {
            date = this.date;
            String val = evt.get(this.variable);
            if (val == null) {
                System.out.println("Variable '" + this.variable + "' cannot be extracted from event " + evt.getEventId() + ", falling back to event.date comparison!");
            }
            evtDate = new Date(new Long(val));
        }
        catch (Exception e) {
            evtDate = evt.getDate();
        }
        switch (this.getOp()) {
            case GT: {
                return evtDate.after(date);
            }
            case GE: {
                return evtDate.equals(date) || evt.getDate().after(date);
            }
            case LT: {
                return evtDate.before(date);
            }
            case LE: {
                return evtDate.equals(date) || evt.getDate().before(date);
            }
        }
        return evtDate.equals(date);
    }

    @Override
    public Object readResolve() {
        return this;
    }

    public List<String> getSupportedOperators() {
        LinkedList<String> list = new LinkedList<String>();
        list.add(Operator.EQ.toString());
        list.add(Operator.LT.toString());
        list.add(Operator.GT.toString());
        list.add(Operator.GE.toString());
        list.add(Operator.LE.toString());
        return list;
    }

    @Override
    public String toXML() {
        XStream xs = new XStream();
        xs.processAnnotations(AuditEventDateMatch.class);
        return xs.toXML((Object)this);
    }
}

