/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.AuditEventSource;

public class BufferedAuditEventSource
extends Thread
implements AuditEventSource {
    private LinkedBlockingQueue<AuditEvent> events;
    private AuditEventReader reader;

    public BufferedAuditEventSource(AuditEventReader evtReader) {
        this(evtReader, 1000);
    }

    public BufferedAuditEventSource(AuditEventReader evtReader, int bufSize) {
        this.reader = evtReader;
        this.events = new LinkedBlockingQueue(bufSize);
    }

    @Override
    public boolean hasNext() {
        return !this.events.isEmpty();
    }

    @Override
    public AuditEvent nextEvent() {
        return this.events.poll();
    }

    @Override
    public void setFilter(AuditEventFilter filter) {
    }

    @Override
    public void run() {
        try {
            block2: while (true) {
                AuditEvent evt = null;
                while (this.events.remainingCapacity() == 0) {
                    Thread.sleep(256L);
                }
                while (true) {
                    if (this.events.remainingCapacity() <= 0) continue block2;
                    evt = this.reader.readNext();
                    if (evt != null) {
                        this.events.add(evt);
                        continue;
                    }
                    Thread.sleep(256L);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

