/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jwall.web.audit.io.LineReader;

public class DefaultLineReader
implements LineReader {
    BufferedReader reader;
    Long bytesRead = 0L;

    public DefaultLineReader(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public String readLine() {
        try {
            String line = this.reader.readLine();
            this.bytesRead = this.bytesRead + (long)line.getBytes().length;
            return line;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSource() {
        return "input-stream";
    }

    @Override
    public void skip(Long bytes) {
        try {
            Long skipped = this.reader.skip(bytes);
            this.bytesRead = this.bytesRead + skipped;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Long bytesRead() {
        return this.bytesRead;
    }
}

