/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.AuditEventWriter;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ModSecurity2AuditWriter;
import org.jwall.web.audit.util.Base64Codec;

public class AuditEventMLogcReceiver
extends Thread
implements AuditEventListener {
    ServerSocket socket;
    AuditEventWriter writer;

    public AuditEventMLogcReceiver() throws Exception {
        URL url = AuditEventMLogcReceiver.class.getResource("/org/jwall/web/audit/net/keystore");
        System.out.println("using certificate @ " + url);
        InputStream keystream = url.openStream();
        char[] passphrase = "geheim".toCharArray();
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(keystream, passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, passphrase);
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = kmf.getKeyManagers();
        context.init(keyManagers, null, null);
        SSLServerSocketFactory ssf = context.getServerSocketFactory();
        this.socket = ssf.createServerSocket(8886);
        System.out.println("Starting MLogc, listening at " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getLocalPort());
        this.writer = new ModSecurity2AuditWriter(new File("/tmp/receiver-test-audit.log"));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket client = this.socket.accept();
                    System.out.println("new mlogc-connection!");
                    AuditEventSocketReader reader = new AuditEventSocketReader(client, this);
                    reader.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void eventArrived(String sensorId, AuditEvent evt) {
        this.eventArrived(evt);
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        try {
            System.out.println("ScriptEvent arrived!");
            this.writer.writeEvent(evt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> evts) {
        for (AuditEvent evt : evts) {
            this.eventArrived(evt);
        }
    }

    public static void main(String[] args) {
        try {
            AuditEventMLogcReceiver receiver = new AuditEventMLogcReceiver();
            receiver.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class AuditEventSocketReader
    extends Thread {
        Socket sock;
        InputStream in;
        AuditEventMLogcReceiver listener;
        BufferedReader reader;
        PrintStream out;

        public AuditEventSocketReader(Socket socket, AuditEventMLogcReceiver listener) throws IOException {
            this.sock = socket;
            this.in = this.sock.getInputStream();
            this.listener = listener;
            this.reader = new BufferedReader(new InputStreamReader(this.in));
            this.out = new PrintStream(this.sock.getOutputStream());
        }

        public AuditEvent readEvent() {
            try {
                StringBuffer header = new StringBuffer();
                int contentLength = 0;
                String sensorId = null;
                String line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                while (line != null && !line.trim().equals("")) {
                    System.out.println("line: " + line);
                    header.append(line + "\n");
                    if (line.toLowerCase().startsWith("content-length: ")) {
                        contentLength = Integer.parseInt(line.substring("content-length: ".length()));
                        System.out.println("Found content length: " + contentLength);
                    }
                    if (line.toLowerCase().startsWith("authentication:")) {
                        String[] t = line.substring("authentication".length()).split(" ");
                        Base64Codec codec = new Base64Codec();
                        String userpass = new String(codec.decode(t[1].getBytes()));
                        int k = 0;
                        for (int i = userpass.length() - 1; i >= 0; --i) {
                            if (userpass.charAt(i) != ':') continue;
                            k = i;
                            i = -1;
                        }
                        sensorId = userpass.substring(0, k);
                    }
                    line = this.reader.readLine();
                }
                header.append("\n");
                System.out.println("Header:\n" + header.toString());
                StringBuffer eventData = new StringBuffer();
                while (contentLength > 0) {
                    eventData.append((char)this.reader.read());
                    --contentLength;
                }
                System.out.println("ScriptEvent:\n" + eventData);
                ModSecurity2AuditReader reader = new ModSecurity2AuditReader(new StringReader(eventData.toString()));
                AuditEvent evt = reader.readNext();
                if (evt != null) {
                    System.out.println("Sending 200 OK");
                    this.out.print("HTTP/1.1 200 OK\r\n");
                } else {
                    System.out.println("Sending 500 Error");
                    this.out.print("HTTP/1.1 500 Error\r\n");
                }
                this.out.print("X-Server: jwall.org AuditEventMLogcReceiver\r\n");
                this.out.print("Content-Length: 0\r\n");
                this.out.print("Content-Type: text/plain\r\n");
                this.out.print("\r\n\r\n");
                this.out.flush();
                this.listener.eventArrived(sensorId, evt);
                return evt;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void run() {
            try {
                block4: while (true) {
                    AuditEvent evt = this.readEvent();
                    while (true) {
                        if (evt != null) continue block4;
                        try {
                            System.out.println("Sleeping...");
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        evt = this.readEvent();
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

