/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.io.AuditEventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAuditEventSource
extends Thread
implements AuditEventSource {
    private static Logger log = LoggerFactory.getLogger((String)"NetworkAuditEventSource");
    Socket socket;
    ObjectInputStream in;
    PrintStream out;
    Queue<ModSecurityAuditEvent> queue;
    List<AuditEventListener> listeners;
    boolean closed = false;

    protected NetworkAuditEventSource(Socket s) throws Exception {
        this.socket = s;
        this.in = new ObjectInputStream(this.socket.getInputStream());
        this.out = new PrintStream(this.socket.getOutputStream());
        this.queue = new LinkedBlockingQueue<ModSecurityAuditEvent>();
        this.listeners = new LinkedList<AuditEventListener>();
    }

    public NetworkAuditEventSource(String host, int port, boolean ssl) throws Exception {
        this(new Socket(host, port));
    }

    public void addEventListener(AuditEventListener l) {
        this.listeners.add(l);
    }

    public void removeEventListener(AuditEventListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public ModSecurityAuditEvent nextEvent() {
        return this.queue.poll();
    }

    @Override
    public void setFilter(AuditEventFilter f) {
        this.out.println(f.toXML());
        this.out.flush();
    }

    public boolean connect(String login, String pass) throws Exception {
        String s = (String)this.in.readObject();
        if ("LOGIN".equals(s)) {
            this.out.println(login);
        }
        if ("PASSWORD".equals(s = (String)this.in.readObject())) {
            this.out.println(pass);
        }
        s = (String)this.in.readObject();
        return "LOGIN OK".equals(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                while (!this.closed) {
                    try {
                        ModSecurityAuditEvent e = (ModSecurityAuditEvent)this.in.readObject();
                        if (e == null) continue;
                        log.debug("received event-object!");
                        this.queue.add(e);
                        Iterator<AuditEventListener> l = this.listeners.iterator();
                        while (l.hasNext()) {
                            l.next().eventArrived(e);
                        }
                    }
                    catch (EOFException eof) {
                        Thread.sleep(256L);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.in.close();
            this.socket.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.interrupt();
            this.out.println("DISCONNECT");
            this.out.flush();
            this.listeners.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.closed = true;
    }
}

