/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.net.Dispatcher;
import org.jwall.web.audit.net.NetworkClientWorkerThread;
import org.jwall.web.audit.util.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkEventServer
extends Thread
implements AuditEventListener {
    public static final int CLIENT_POLL_TIME = 256;
    private static Logger log = LoggerFactory.getLogger((String)"NetworkEventServer");
    ServerSocket socket;
    Authenticator users = null;
    Dispatcher dispatcher;

    public NetworkEventServer(String s, Authenticator auth) throws Exception {
        this(s, 10001, auth);
    }

    public NetworkEventServer(String serv, int port, Authenticator auth) throws Exception {
        this.users = auth;
        this.dispatcher = new Dispatcher(256);
        this.socket = new ServerSocket(port, 10, InetAddress.getByName(serv));
    }

    public NetworkEventServer(int port, Authenticator auth) throws Exception {
        this.users = auth;
        this.dispatcher = new Dispatcher(256);
        this.socket = new ServerSocket(port, 10);
    }

    private NetworkEventServer(ServerSocket ssocket, Authenticator auth) {
        this.users = auth;
        this.dispatcher = new Dispatcher(256);
        this.socket = ssocket;
    }

    @Override
    public void start() {
        super.start();
        this.dispatcher.start();
    }

    public static NetworkEventServer createSSLEventServer(File keyFile, String pass, int port, Authenticator auth) throws Exception {
        return NetworkEventServer.createSSLEventServer(new FileInputStream(keyFile), pass, port, auth);
    }

    public static NetworkEventServer createSSLEventServer(InputStream keyIn, int port, Authenticator auth) throws Exception {
        return NetworkEventServer.createSSLEventServer(keyIn, "geheim", port, auth);
    }

    public static NetworkEventServer createSSLEventServer(InputStream keyStream, String pass, int port, Authenticator auth) throws Exception {
        char[] passphrase = pass.toCharArray();
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(keyStream, passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, passphrase);
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = kmf.getKeyManagers();
        context.init(keyManagers, null, null);
        SSLServerSocketFactory ssf = context.getServerSocketFactory();
        ServerSocket ss = ssf.createServerSocket(port);
        NetworkEventServer srv = new NetworkEventServer(ss, auth);
        return srv;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket sock = this.socket.accept();
                    NetworkClientWorkerThread worker = new NetworkClientWorkerThread(sock, this.users, this);
                    this.dispatcher.registerClient(worker);
                    worker.start();
                }
            }
            catch (SSLException se) {
                log.error("Cannot establish SSL-socket connection due to ssl-problems: {}", (Object)se.getMessage());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void eventArrived(AuditEvent e) {
        this.dispatcher.enqueueEvents(e);
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    public void unregisterClient(NetworkClientWorkerThread t) {
        this.dispatcher.unregisterClient(t);
    }
}

