/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ParseException;
import org.jwall.web.audit.net.SyslogAuditEventStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogAuditEventMultiStream
extends SyslogAuditEventStream
implements AuditEventReader,
Runnable {
    static Logger log = LoggerFactory.getLogger(SyslogAuditEventMultiStream.class);
    boolean tail;
    Integer lines = 0;
    String prefix = null;
    String sensor = "";
    AuditEventListener listener;
    boolean base64 = false;
    boolean autoDetection = true;
    Map<String, String> pendingIDs = new HashMap<String, String>();
    Map<String, StringBuffer[]> pending = new HashMap<String, StringBuffer[]>();
    PrintStream out;
    StringBuffer current = new StringBuffer();

    public SyslogAuditEventMultiStream(InputStream in, AuditEventListener listener) throws IOException {
        super(in, listener, true);
        File debug = new File("/tmp/debug-audit.log");
        int i = 0;
        while (debug.exists()) {
            debug = new File("/tmp/debug-audit.log-" + i);
            ++i;
        }
        log.info("Writing debug-copy of received data to {}", (Object)debug);
        this.out = new PrintStream(new FileOutputStream(debug));
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException, EOFException {
        ++this.counter;
        String[] line = this.readLine();
        long offset = (long)this.getDataRead();
        StringBuffer[] sections = this.getBuffers(line[0]);
        int ptr = 0;
        try {
            while (!line[1].matches("--[\\-\\@0-9A-Za-z]*-A--")) {
                log.info("Skipping to start of next event...");
                line = this.readLine();
                this.bytesRead += (double)line[1].length() + 1.0;
            }
            String id = line[1].replaceFirst("--", "").replaceAll("-A--", "");
            this.pendingIDs.put(line[0], id);
            while (!line[1].startsWith("--") || !line[1].endsWith("-Z--")) {
                if (line[1].matches("--[\\-\\@0-9A-Za-z]*-A--")) {
                    log.debug("Start of new event found: {}", (Object)line[1]);
                    this.current.append(line[1] + "\n");
                    sections = this.initBuffers(line[0]);
                    this.bytesRead += (double)line[1].length() + 1.0;
                }
                ptr = SyslogAuditEventMultiStream.getSectionIndex(line[1]);
                do {
                    line = this.readLine();
                    this.current.append(line[1] + "\n");
                } while ((sections = this.getBuffers(line[0])) == null);
                this.bytesRead += (double)line[1].length() + 1.0;
                if (ptr >= 0) {
                    sections[ptr] = new StringBuffer();
                    do {
                        log.debug("Appending line to buffer for key '{}'", (Object)line[0]);
                        sections[ptr].append(line[1] + "\n");
                        line = this.readLine();
                        this.current.append(line[1] + "\n");
                        sections = this.getBuffers(line[0]);
                        this.bytesRead += (double)line[1].length();
                    } while (!line[1].trim().matches("^--[\\-\\@0-9A-Za-z]*-Z--$"));
                    continue;
                }
                log.debug("Line contains invalid section-name: " + line);
            }
            String[] tok = this.current.toString().split("^--.*-[A-Z]--$");
            String sensorName = tok[tok.length - 1];
            String[] data = new String["ABCDEFGHIJKTXZ".length()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = sections[i].toString();
            }
            if (data[0].equals("")) {
                return null;
            }
            log.debug("Removing buffers for key '{}'", (Object)line[0]);
            this.pending.remove(line[0]);
            log.debug("{} buffers currently pending", (Object)this.pending.size());
            AuditEvent event = this.eventFactory.createAuditEvent(this.pendingIDs.get(line[0]), data, this.inputFile, offset, (long)this.bytesRead - offset, AuditEventType.ModSecurity2);
            event.set("SENSOR_NAME", sensorName);
            log.info("{} lines read", (Object)this.lines);
            return event;
        }
        catch (EOFException eof) {
            log.warn("End-of-file reached!");
            this.eofReached = true;
            throw eof;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException("End of file reached!");
        }
        Integer n = this.lines;
        Integer n2 = this.lines = Integer.valueOf(this.lines + 1);
        if (this.lines % 1000 == 0) {
            log.info("{} lines read so far");
        }
        String prio = "";
        int prioEnd = line.indexOf(">");
        if (prioEnd > 0) {
            prio = line.substring(0, prioEnd + 1) + " ";
        }
        int idx = line.indexOf(": ");
        String pre = line.substring(0, idx);
        String data = line.substring(idx + 2);
        String[] tok = pre.split(" ");
        String key = prio + tok[tok.length - 2] + " " + tok[tok.length - 1];
        if (this.out != null) {
            this.out.println(data);
        }
        if (this.base64) {
            log.info("Decoding base64 data '{}'", (Object)data);
            Base64 b64 = new Base64();
            data = new String(b64.decode(data));
            log.info("   => {}", (Object)data);
        }
        return new String[]{key, data};
    }

    public StringBuffer[] getBuffers(String key) {
        if (this.pending.containsKey(key)) {
            return this.pending.get(key);
        }
        log.debug("No buffers for key '{}' pending", (Object)key);
        return null;
    }

    public StringBuffer[] initBuffers(String key) {
        log.debug("Initializing new buffers for key '{}'", (Object)key);
        StringBuffer[] buf = new StringBuffer["ABCDEFGHIJKTXZ".length()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = new StringBuffer();
        }
        if (this.pending.containsKey(key)) {
            log.warn("Partial event found for key '{}'!", (Object)key);
        }
        this.pending.put(key, buf);
        return buf;
    }

    @Override
    public void run() {
        try {
            while (true) {
                AuditEvent event = this.readNext();
                this.listener.eventArrived(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

