/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jwall.audit.FeatureExtractor;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.util.QuotedStringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCollectionExtractor
implements FeatureExtractor<AuditEvent, String> {
    static Logger log = LoggerFactory.getLogger(PersistentCollectionExtractor.class);
    final Set<String> variables = new LinkedHashSet<String>();

    public static Map<String, String> extractScores(AuditEvent evt) throws Exception {
        log.debug("Extracting score for event {}", (Object)evt.getEventId());
        return PersistentCollectionExtractor.extractScores(evt, new LinkedHashMap<String, String>());
    }

    public static Map<String, String> processRuleLog(String ruleLog, Map<String, String> env) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(ruleLog));
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                int idx = -1;
                if (line.startsWith("SecAction")) {
                    idx = 1;
                }
                if (line.startsWith("SecRule")) {
                    idx = 3;
                }
                if (line.indexOf("setvar") < 0) {
                    line = reader.readLine();
                    continue;
                }
                if (idx > 0) {
                    ArrayList<String> actions = new ArrayList<String>();
                    List<String> args = QuotedStringTokenizer.splitRespectQuotes(line.trim(), ' ');
                    String actionString = PersistentCollectionExtractor.removeQuotes(args.get(idx));
                    for (String action : QuotedStringTokenizer.splitRespectQuotes(actionString, ',')) {
                        String act = PersistentCollectionExtractor.removeQuotes(action.trim());
                        actions.add(act);
                        PersistentCollectionExtractor.processAction(act, env);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return env;
        }
        catch (Exception e) {
            log.error("Failed to parse K-section of event:\n{}", (Object)ruleLog);
            log.error("   Exception was: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return env;
        }
    }

    public static Map<String, String> extractScores(AuditEvent evt, Map<String, String> env) throws Exception {
        String ruleLog = evt.getSection(10);
        if (ruleLog == null || ruleLog.length() == 0) {
            log.debug("No rule-log found in event! Did you forget to enable the K-section?");
            return env;
        }
        log.debug("Parsing K-section of event {}", (Object)evt.getEventId());
        try {
            BufferedReader reader = new BufferedReader(new StringReader(ruleLog));
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                int idx = -1;
                if (line.startsWith("SecAction")) {
                    idx = 1;
                }
                if (line.startsWith("SecRule")) {
                    idx = 3;
                }
                if (line.indexOf("setvar") < 0) {
                    line = reader.readLine();
                    continue;
                }
                if (idx > 0) {
                    ArrayList<String> actions = new ArrayList<String>();
                    List<String> args = QuotedStringTokenizer.splitRespectQuotes(line.trim(), ' ');
                    String actionString = PersistentCollectionExtractor.removeQuotes(args.get(idx));
                    for (String action : QuotedStringTokenizer.splitRespectQuotes(actionString, ',')) {
                        String act = PersistentCollectionExtractor.removeQuotes(action.trim());
                        actions.add(act);
                        PersistentCollectionExtractor.processAction(act, env);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return env;
        }
        catch (Exception e) {
            log.error("Failed to parse K-section of event {}:\n{}", (Object)evt.getEventId(), (Object)ruleLog);
            log.error("   Exception was: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private static void processAction(String action, Map<String, String> env) {
        if (action.startsWith("setvar")) {
            String[] tok = action.split(":", 2);
            if (tok.length > 1) {
                int idx;
                String setvar = tok[1];
                if (setvar.charAt(0) == '\'') {
                    setvar = setvar.substring(1);
                }
                if (setvar.endsWith("'")) {
                    setvar = setvar.substring(0, setvar.length() - 1);
                }
                if ((idx = setvar.indexOf("=")) > 0) {
                    String var = setvar.substring(0, idx);
                    String val = setvar.substring(idx + 1);
                    log.trace("   found assignment:  {} := {}", (Object)var, (Object)val);
                    String eval = PersistentCollectionExtractor.eval(val, env);
                    String old = env.get(var);
                    if (old == null) {
                        old = "0";
                    }
                    if (eval.startsWith("+")) {
                        try {
                            eval = Integer.parseInt(eval.substring(1)) + Integer.parseInt(old) + "";
                        }
                        catch (Exception e) {
                            log.error("Parse error! Argument to setvar is not an integer: '{}'!", (Object)eval.substring(1));
                            eval = "0";
                        }
                    }
                    if (eval.startsWith("-")) {
                        try {
                            eval = Integer.parseInt(old) - Integer.parseInt(eval.substring(1)) + "";
                        }
                        catch (Exception e) {
                            log.error("Parse error! Argument to setvar is not an integer: '{}'!", (Object)eval.substring(1));
                            eval = "0";
                        }
                    }
                    log.trace("           setting   {} := {}", (Object)var, (Object)eval);
                    env.put(var, eval);
                }
            }
            return;
        }
        log.debug("Ignoring action {}", (Object)action);
    }

    public static String removeQuotes(String s) {
        int start = 0;
        if (s.startsWith("\"")) {
            s = s.substring(++start);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String eval(String str, Map<String, String> env) {
        if (str.indexOf("%{") >= 0) {
            for (String key : env.keySet()) {
                if (str.indexOf("%{" + key + "}") < 0) continue;
                str = str.replace("%{" + key + "}", env.get(key));
            }
            return str;
        }
        return str;
    }

    @Override
    public Set<String> getVariables(AuditEvent event) {
        return this.variables;
    }

    @Override
    public String extract(String feature, AuditEvent event) {
        try {
            Map<String, String> scores = PersistentCollectionExtractor.extractScores(event);
            String key = feature.toLowerCase().replace(':', '.');
            return scores.get(key);
        }
        catch (Exception e) {
            log.error("Failed to extract '{}': {}", (Object)feature, (Object)e.getMessage());
            return null;
        }
    }
}

