/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jwall.web.audit.util.Authenticator;

public class SimplePasswordAuthenticator
implements Authenticator {
    protected Properties users;
    protected Properties groups;
    protected MessageDigest md = null;

    public SimplePasswordAuthenticator(Properties usersFile, Properties groupFile) {
        this.users = usersFile;
        this.groups = groupFile;
    }

    public SimplePasswordAuthenticator(Properties usersFile, Properties groupFile, MessageDigest messageDigest) {
        this(usersFile, groupFile);
        this.md = messageDigest;
    }

    @Override
    public boolean authenticate(String login, String password) {
        String pass = password;
        if (this.md != null) {
            pass = new String(this.md.digest(password.getBytes()));
        }
        return this.users.get(login) != null && this.users.get(login).equals(pass);
    }

    @Override
    public List<String> getRoles(String user) {
        String[] s;
        if (user == null || this.groups.get(user) == null) {
            return new LinkedList<String>();
        }
        LinkedList<String> roles = new LinkedList<String>();
        for (String role : s = this.groups.get(user).toString().split(",")) {
            roles.add(role.trim());
        }
        return roles;
    }

    @Override
    public boolean isUserInRole(String user, String role) {
        return this.getRoles(user).contains(role);
    }
}

