/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http;

import java.net.URL;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.HttpMessage;
import org.jwall.web.http.MessageFormatException;
import org.jwall.web.http.ProtocolException;

public class HttpRequest
extends HttpMessage {
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String TE = "TE";
    public static final String USER_AGENT = "User-Agent";
    String method = "";
    String uri = "";
    URL url = null;

    public HttpRequest(String reqHeader, byte[] reqBody) throws ProtocolException {
        super(new HttpHeader(reqHeader), reqBody);
        this.parseStartLine(this.header.startLine);
    }

    public HttpRequest(HttpHeader h, byte[] reqBody) throws ProtocolException {
        super(h, reqBody);
        this.parseStartLine(this.header.startLine);
    }

    public HttpRequest(String reqHeader) throws Exception {
        this(reqHeader, new byte[0]);
    }

    @Override
    protected void parseStartLine(String line) throws MessageFormatException {
        try {
            String[] tok = line.split(" ");
            this.method = tok[0];
            this.uri = tok[1];
            this.version = tok[2];
        }
        catch (Exception e) {
            throw new MessageFormatException("Invalid request-line: " + line);
        }
        try {
            String host = this.getHeader(HOST);
            String proto = "http";
            String sep = "/";
            if (this.uri.startsWith("/")) {
                sep = "";
            }
            this.url = new URL(proto + "://" + host + sep + this.uri);
        }
        catch (Exception e) {
            throw new MessageFormatException("Error while constructing the URL: " + e.getLocalizedMessage());
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public URL getURL() {
        return this.url;
    }
}

