/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.Configurable;
import stream.Data;
import stream.ProcessContext;
import stream.Processor;
import stream.StatefulProcessor;
import stream.dashboard.DataListener;
import stream.dashboard.Widget;
import stream.dashboard.WidgetMover;
import stream.io.SourceURL;
import stream.net.JSONReceiver;
import stream.runtime.ProcessContextImpl;
import stream.runtime.setup.ObjectFactory;
import stream.util.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dashboard
extends JFrame
implements StatefulProcessor,
Configurable {
    static Logger log = LoggerFactory.getLogger(Dashboard.class);
    private static final long serialVersionUID = 8494360239506665376L;
    final List<Widget> widgets = new ArrayList<Widget>();
    final List<JInternalFrame> frames = new ArrayList<JInternalFrame>();
    final JDesktopPane content = new JDesktopPane();
    final JPanel display = this.createContentPane();
    final List<Widget> processors = new ArrayList<Widget>();
    final ProcessContext ctx = new ProcessContextImpl();
    String message = null;
    JSONReceiver receiver;
    SourceURL config;
    protected final List<String> nameSpaces = new ArrayList<String>();

    public Dashboard() {
        this.nameSpaces.add("stream.dashboard");
        this.setTitle("Dashboard");
        this.setSize(1024, 768);
        this.content.setBackground(Color.WHITE);
        this.display.setBackground(Color.WHITE);
        this.setContentPane(this.display);
        WidgetMover m = new WidgetMover(this);
        this.addMouseMotionListener(m);
        this.display.addMouseMotionListener(m);
        this.display.addMouseListener(m);
    }

    public JPanel createContentPane() {
        return new JPanel(null);
    }

    public void init(URL url) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(url.openStream());
        this.init(doc);
    }

    public void init(SourceURL url) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(url.openStream());
        this.init(doc);
    }

    public void init(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        this.init(root);
    }

    public void init(Element root) throws Exception {
        ObjectFactory factory = ObjectFactory.newInstance();
        for (String pkg : this.nameSpaces) {
            factory.addPackage(pkg.trim());
        }
        String host = "0.0.0.0";
        try {
            if (root.hasAttribute("address")) {
                host = root.getAttribute("address");
            }
            Integer port = new Integer(root.getAttribute("port"));
            log.info("Listening for JSON streams on {}:{}", (Object)host, (Object)port);
            this.receiver = new JSONReceiver(host, port);
            this.receiver.registerListener(new DataListener(){

                public void dataArrived(Data item) {
                    Dashboard.this.process(item);
                }
            });
            this.receiver.start();
        }
        catch (Exception e) {
            log.error("Error: " + e.getMessage());
        }
        try {
            Dimension d = this.parseDimension(root.getAttribute("ui:size"));
            this.setSize(d);
        }
        catch (Exception e) {
            // empty catch block
        }
        NodeList ch = root.getChildNodes();
        for (int i = 0; i < ch.getLength(); ++i) {
            Node c = ch.item(i);
            if (c.getNodeType() != 1) continue;
            Element el = (Element)c;
            log.info("Creating widget from element '{}'", (Object)el);
            Widget widget = (Widget)factory.create(el);
            this.add(widget);
            String loc = el.getAttribute("ui:location");
            if (loc == null || "".equals(loc.trim())) {
                loc = "10,10";
            }
            Point pt = this.parseLocation(loc);
            log.info("Point: {}", (Object)pt);
            widget.setLocation(pt);
            String size = el.getAttribute("ui:size");
            if (size == null || "".equals(size.trim())) {
                size = "320,240";
            }
            Dimension sz = this.parseDimension(size);
            log.info("Size: {}", (Object)sz);
            widget.setSize(sz);
        }
    }

    public int gridSize() {
        return 10;
    }

    public void add(Widget w) {
        try {
            w.init(this.ctx);
            if (w instanceof Processor) {
                this.processors.add(w);
            }
            this.display.add(w);
            this.widgets.add(w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void init(ProcessContext context) throws Exception {
        try {
            if (this.config != null) {
                Document doc = XMLUtils.parseDocument((InputStream)this.config.openStream());
                this.init(doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Failed to initialize Dashboard: " + e.getMessage());
        }
        this.setVisible(true);
    }

    public Data process(Data item) {
        for (Widget w : this.processors) {
            if (w.handles(item)) {
                log.debug("Handling item {} with widget {}", (Object)item, (Object)w);
                w.process(item);
                continue;
            }
            log.debug("Skipping widget {} for item {}", (Object)w, (Object)item);
        }
        return item;
    }

    public void resetState() throws Exception {
    }

    public void finish() throws Exception {
    }

    public void message(String msg) {
        this.message = msg;
        this.repaint();
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.message != null) {
            g.drawString(this.message, this.getWidth() / 2, 50);
        }
    }

    public Dimension parseDimension(String s) {
        log.info("Parsing dimension from {}", (Object)s);
        String[] tok = s.split(",", 2);
        return new Dimension(new Integer(tok[0]), new Integer(tok[1]));
    }

    public Point parseLocation(String s) {
        log.info("Parsing location from {}", (Object)s);
        String[] tok = s.split(",", 2);
        return new Point(new Integer(tok[0]), new Integer(tok[1]));
    }

    public SourceURL getConfig() {
        return this.config;
    }

    public void setConfig(SourceURL config) {
        this.config = config;
    }

    public void configure(Element document) {
        if (document != null) {
            try {
                log.info("Building dashboard from nested XML config..");
                this.init(document);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

