/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.dashboard.ColorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultColorMapping
implements ColorMapping {
    static Logger log = LoggerFactory.getLogger(DefaultColorMapping.class);
    private static DefaultColorMapping colorMapping = new DefaultColorMapping();
    Map<String, Color> colorMappings = new LinkedHashMap<String, Color>();

    public DefaultColorMapping() {
        try {
            URL url = DefaultColorMapping.class.getResource("/colors.properties");
            if (url != null) {
                log.debug("Found color-mapping at: {}", (Object)url);
                Map<String, Color> cols = DefaultColorMapping.readColorMap(url.openStream());
                this.addColors(cols);
            } else {
                log.warn("No color-mapping found!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File colorFile = new File(System.getProperty("user.home") + File.separator + ".colors.properties");
            if (colorFile.exists()) {
                log.debug("Loading custom color mapping from {}", (Object)colorFile);
                Map<String, Color> colors = DefaultColorMapping.readColorMap(new FileInputStream(colorFile));
                this.addColors(colors);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ColorMapping getInstance() {
        if (colorMapping == null) {
            colorMapping = new DefaultColorMapping();
        }
        return colorMapping;
    }

    public void set(String aspect, String value, Color c) {
        this.colorMappings.put(aspect + "." + value, c);
    }

    @Override
    public Color map(String aspect, String value) {
        Color color = this.colorMappings.get(aspect + "." + value);
        if (color == null) {
            log.debug("No color defined for {}={}", (Object)aspect, (Object)value);
            color = this.getNextAvailableColor(aspect);
            if (color != null) {
                this.colorMappings.put(aspect + "." + value, color);
            }
        } else {
            log.debug("   {}={} ~> " + this.getHtmlCode(color), (Object)aspect, (Object)value);
        }
        if (color == null) {
            return Color.lightGray;
        }
        return color;
    }

    public Color getNextAvailableColor(String aspect) {
        int count = 0;
        for (String key : this.colorMappings.keySet()) {
            if (!key.startsWith(aspect)) continue;
            ++count;
        }
        log.debug("Aspect '{}' has {} colors defined", (Object)aspect, (Object)count);
        Color last = this.colorMappings.get(aspect);
        if (last == null) {
            log.debug("No base-color defined for aspect '{}'!", (Object)aspect);
            return null;
        }
        log.debug("  last assigned color for {} is {}", (Object)aspect, (Object)this.getHtmlCode(last));
        float angle = 0.16666667f;
        float saturation = 1.0f;
        float brightness = (float)count * 0.025f;
        log.debug(" angle = {}");
        log.debug(" saturation = {}", (Object)Float.valueOf(saturation));
        log.debug(" brightness = {}", (Object)Float.valueOf(brightness));
        last = Color.getHSBColor(angle, saturation, brightness);
        this.colorMappings.put(aspect + "." + count, last);
        log.debug("   last.brigther is {}", (Object)this.getHtmlCode(last));
        return last;
    }

    public static Color getColorForCode(String code) {
        log.debug("Checking color from code '{}'", (Object)code);
        try {
            if (code.startsWith("#") && code.length() == 7) {
                String c1 = code.substring(1, 3);
                String c2 = code.substring(3, 5);
                String c3 = code.substring(5);
                log.debug("  c1 = {}, c2 = {}, c3 = " + c3, (Object)c1, (Object)c2);
                int r = Integer.parseInt(c1, 16);
                int g = Integer.parseInt(c2, 16);
                int b = Integer.parseInt(c3, 16);
                log.debug("  r/g/b = " + r + "/" + g + "/" + b);
                Color c = new Color(r, g, b);
                return c;
            }
            log.warn("Invalid color-definition! Only html-color codes are currently supported!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addColors(Map<String, Color> colors) {
        for (String key : colors.keySet()) {
            this.colorMappings.put(key, colors.get(key));
        }
    }

    public String getHtmlCode(Color color) {
        String b;
        String g;
        String r = Integer.toHexString(color.getRed());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(color.getGreen())).length() == 1) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(color.getBlue())).length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    public Set<String> getMappedValues(String aspect) {
        TreeSet<String> values = new TreeSet<String>();
        for (String key : this.colorMappings.keySet()) {
            if (!key.startsWith(aspect + ".")) continue;
            values.add(key.substring(aspect.length() + 1));
        }
        return values;
    }

    public static Map<String, Color> readColorMap(InputStream in) {
        LinkedHashMap<String, Color> colors = new LinkedHashMap<String, Color>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = r.readLine();
            while (line != null) {
                int idx;
                line = line.trim();
                log.debug("Line: {}", (Object)line);
                if (!line.equals("") && line.indexOf("=") > 0 && !line.startsWith("#") && (idx = line.indexOf("=")) > 0) {
                    String key = line.substring(0, idx);
                    String code = line.substring(idx + 1);
                    if (key.equalsIgnoreCase("AUTO_COLORS")) {
                        String[] colorCodes;
                        int i = 0;
                        for (String cc : colorCodes = code.split(",")) {
                            Color col = DefaultColorMapping.getColorForCode(cc);
                            if (col == null) continue;
                            colors.put("AUTO_COLORS_" + i, col);
                        }
                    } else {
                        Color color = DefaultColorMapping.getColorForCode(code);
                        log.debug("Registering color '{}' for key '{}'", (Object)color, (Object)key);
                        colors.put(key, color);
                    }
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colors;
    }
}

