/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.data.Statistics;

public class MatrixChart
extends JPanel {
    static Logger log = LoggerFactory.getLogger(MatrixChart.class);
    private static final long serialVersionUID = -5309535228880758642L;
    static final Color LINE_COLOR = new Color(224, 224, 224);
    Set<String> columns = new TreeSet<String>();
    Set<String> rows = new TreeSet<String>();
    Statistics switches = new Statistics();
    int border;
    int borderx = this.border = 25;
    int bordery = this.border;
    double total = 1.0;
    List<String> history = new ArrayList<String>();

    public MatrixChart() {
        this.setBackground(Color.WHITE);
        this.setBorder(null);
    }

    public void reset() {
        this.total = 1.0;
        this.switches.clear();
        this.rows.clear();
        this.columns.clear();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        log.debug("Switch matrix has dimension {} x {}", (Object)this.rows.size(), (Object)this.columns.size());
        Double baseSize = 28.0;
        String mrk = null;
        for (String k : this.rows) {
            if (mrk != null && mrk.length() >= k.length()) continue;
            mrk = k;
        }
        log.debug("Longest row-key is: {}", mrk);
        if (mrk == null) {
            mrk = "XXXXXXXX";
        }
        Rectangle2D r2 = g.getFontMetrics().getStringBounds(mrk, g);
        this.borderx = (int)(r2.getWidth() + 5.0);
        String mck = null;
        for (String k : this.rows) {
            if (mck != null && mck.length() >= k.length()) continue;
            mck = k;
        }
        if (mck == null) {
            mck = "         ";
        }
        if (g.getFontMetrics() == null) {
            return;
        }
        r2 = g.getFontMetrics().getStringBounds(mck, g);
        this.bordery = (int)(r2.getWidth() * 0.4 + 5.0);
        log.debug("Longest col-key is: {}", (Object)mck);
        log.debug("borderx: {}, bordery: {}", (Object)this.borderx, (Object)this.bordery);
        Font f = g.getFont().deriveFont(9.0f);
        g.setFont(f);
        int row = 0;
        int col = 0;
        for (String rowKey : this.rows) {
            for (String colKey : this.columns) {
                Color orig = g.getColor();
                g.setColor(Color.LIGHT_GRAY);
                Double cx = (double)this.borderx + baseSize * (double)col + 0.5 * baseSize;
                Double cy = (double)this.bordery + baseSize * (double)row + 0.5 * baseSize;
                if (col == 0) {
                    g2.setColor(LINE_COLOR);
                    g2.drawLine(this.borderx, cy.intValue(), this.borderx + baseSize.intValue() * this.columns.size(), cy.intValue());
                    g.setColor(Color.DARK_GRAY);
                    g.drawString(rowKey, 5, cy.intValue() + 4);
                }
                if (row == 0) {
                    g.setColor(LINE_COLOR);
                    g2.drawLine(cx.intValue(), this.bordery, cx.intValue(), this.bordery + baseSize.intValue() * this.rows.size());
                    AffineTransform origt = g2.getTransform();
                    g.setColor(Color.DARK_GRAY);
                    g2.translate(cx.intValue(), this.bordery - 5);
                    g2.rotate(-0.39269908169872414);
                    g2.drawString(colKey, 0, 0);
                    g2.setTransform(origt);
                }
                g.setColor(orig);
                String key = rowKey + ":" + colKey;
                Double value = (Double)this.switches.get((Object)key);
                if (value != null) {
                    Double size = this.getSize(baseSize, key, value);
                    g.setColor(Color.GRAY);
                    int halfx = size.intValue() / 2;
                    int halfy = size.intValue() / 2;
                    g.setColor(Color.pink);
                    if (this.ageInSeconds(key) < 10.0) {
                        g.setColor(Color.RED);
                    }
                    g.fillOval(cx.intValue() - halfx, cy.intValue() - halfy, size.intValue(), size.intValue());
                }
                g.setColor(Color.black);
                ++col;
            }
            ++row;
            col = 0;
        }
    }

    protected Double ageInSeconds(String key) {
        Double ageInSeconds = ((double)System.currentTimeMillis() - (Double)this.switches.get((Object)key)) / 1000.0;
        return ageInSeconds;
    }

    protected Double getSize(Double baseSize, String key, Double value) {
        Double ageInSeconds = this.ageInSeconds(key);
        if (ageInSeconds <= 0.0) {
            ageInSeconds = 10.0;
        }
        log.info("Key '{}' is {} seconds old...", (Object)key, (Object)ageInSeconds);
        value = 10.0 - ageInSeconds;
        return Math.max(3.0, 0.1 * value * baseSize);
    }

    public void add(String from, String to) {
        Long time = System.currentTimeMillis();
        this.rows.add(from);
        this.columns.add(to);
        String key = from + ":" + to;
        this.switches.add(key, Double.valueOf(time.doubleValue()));
        while (this.history.size() > 10) {
            this.history.remove(0);
        }
        this.history.add(key);
        this.total += 0.1;
        this.repaint();
    }

    public void tick() {
        this.total += 1.0;
        this.repaint();
    }
}

