/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.io.Serializable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.dashboard.Message;
import stream.dashboard.Widget;
import stream.dashboard.renderer.MessageRenderer;

public class Messages
extends Widget {
    static Logger log = LoggerFactory.getLogger(Messages.class);
    private static final long serialVersionUID = -6439498544151510135L;
    final MessageList listModel = new MessageList();
    final JList<Message> list = new JList<Message>(this.listModel);
    String key = null;
    int max = 10;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.setTitle("Messages");
        this.list.setCellRenderer(new MessageRenderer());
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(null);
        this.content.add(this.list);
    }

    public Data process(Data input) {
        if (input == null || this.key == null) {
            return input;
        }
        Serializable value = (Serializable)input.get((Object)this.key);
        log.info("{} = {}", (Object)this.key, (Object)value);
        if (value == null) {
            return input;
        }
        String msg = value.toString();
        log.info("Message is: {}", (Object)msg);
        this.listModel.addElement(new Message(msg));
        while (this.listModel.getSize() > this.max) {
            this.listModel.remove(0);
        }
        log.info("Model has {} messages", (Object)this.list.getModel().getSize());
        this.list.validate();
        return input;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageList
    extends DefaultListModel<Message> {
        private static final long serialVersionUID = -2221851153312421414L;
    }
}

