/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Set;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import stream.Data;
import stream.ProcessContext;
import stream.dashboard.PieChart;
import stream.dashboard.Widget;
import stream.data.Statistics;
import stream.util.KeyFilter;

public class Pie
extends Widget {
    private static final long serialVersionUID = -3094354310354207972L;
    String[] keys;
    PieChart chart = new PieChart();
    boolean aggregate = true;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        PiePlot plot = this.chart.getPlot();
        plot.setOutlineVisible(false);
        JFreeChart jfc = new JFreeChart((Plot)plot);
        jfc.setBorderVisible(false);
        jfc.setBackgroundPaint((Paint)Color.WHITE);
        jfc.removeLegend();
        ChartPanel cp = new ChartPanel(jfc);
        cp.setBorder(null);
        cp.setBackground(Color.WHITE);
        this.content.add((Component)cp, "Center");
    }

    public Data process(Data input) {
        if (input == null || this.keys == null || this.keys.length == 0) {
            return input;
        }
        Set selected = KeyFilter.select((Data)input, (String[])this.keys);
        Statistics st = new Statistics();
        for (String key : selected) {
            Double value = 0.0;
            Serializable val = (Serializable)input.get((Object)key);
            if (val != null && val instanceof Number) {
                value = ((Number)val).doubleValue();
            }
            st.put((Object)key, (Object)value);
        }
        if (!st.isEmpty()) {
            if (this.aggregate) {
                this.chart.add(st);
            } else {
                this.chart.set(st);
            }
        }
        return input;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public PieChart getChart() {
        return this.chart;
    }
}

