/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.general.PieDataset;
import stream.dashboard.ColorMapping;
import stream.dashboard.DefaultColorMapping;
import stream.data.Statistics;

public class PieDatasetAdapter
implements PieDataset {
    final ArrayList<String> keys = new ArrayList();
    final List<DatasetChangeListener> listener = new ArrayList<DatasetChangeListener>();
    final Statistics data = new Statistics();
    DatasetGroup group;
    ColorMapping colorMapping = new DefaultColorMapping();
    Map<String, Color> colors = new LinkedHashMap<String, Color>();

    public Comparable getKey(int index) {
        return (Comparable)((Object)this.keys.get(index));
    }

    public int getIndex(Comparable key) {
        return this.keys.indexOf(key);
    }

    public List getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public Number getValue(Comparable key) {
        return (Number)this.data.get((Object)key);
    }

    public int getItemCount() {
        return this.keys.size();
    }

    public Number getValue(int index) {
        String key = this.keys.get(index);
        return (Number)this.data.get((Object)key);
    }

    public void addChangeListener(DatasetChangeListener listener) {
        this.listener.add(listener);
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        this.listener.remove(listener);
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    public void add(Statistics st) {
        for (String key : st.keySet()) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
                this.colors.put(key, this.colorMapping.map("", key));
            }
            this.data.add(key, (Double)st.get((Object)key));
        }
        this.fireDatasetChanged();
    }

    public void set(Statistics st) {
        this.keys.clear();
        this.data.clear();
        this.add(st);
    }

    public void fireDatasetChanged() {
        DatasetChangeEvent evt = new DatasetChangeEvent((Object)this, (Dataset)this);
        for (DatasetChangeListener l : this.listener) {
            l.datasetChanged(evt);
        }
    }
}

