/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Set;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.StatefulProcessor;
import stream.dashboard.TimelineChart;
import stream.dashboard.Widget;
import stream.data.Statistics;
import stream.expressions.Condition;
import stream.util.KeyFilter;
import stream.util.Time;

public class Timeline
extends Widget
implements StatefulProcessor {
    static Logger log = LoggerFactory.getLogger(Timeline.class);
    private static final long serialVersionUID = -5234179636369615078L;
    TimelineChart timeline;
    String[] keys;
    ChartPanel chartPanel;
    Time history = new Time(Long.valueOf(60000L));
    Time interval = new Time(Long.valueOf(1000L));
    Condition condition;

    public Timeline() {
        this(60000L, 1000L);
    }

    public Timeline(Long history, Long step) {
        this.history = new Time(history);
        this.interval = new Time(step);
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.timeline = new TimelineChart(this.history.asMillis(), this.interval.asMillis(), TimelineChart.Type.AreaChart);
        XYPlot plot = this.timeline.getPlot();
        plot.getRenderer().setBaseItemLabelsVisible(false);
        plot.getRenderer().setSeriesShape(0, null);
        plot.getRenderer().setSeriesShape(1, null);
        plot.getRenderer().setSeriesItemLabelsVisible(0, false);
        plot.getRenderer().setSeriesItemLabelsVisible(1, false);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setItemPaint((Paint)new Color(4, 4, 4));
        Font font = new Font("Sans Serif", 0, 10);
        chart.getLegend().setItemFont(font);
        chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        this.chartPanel = new ChartPanel(chart);
        this.content.add((Component)this.chartPanel);
        this.chartPanel.setBackground(Color.WHITE);
    }

    public Data process(Data input) {
        log.trace("Processing {}", (Object)input);
        Long time = System.currentTimeMillis();
        if (input == null || this.keys == null || this.keys.length == 0) {
            return input;
        }
        if (this.condition != null && !this.condition.matches((Context)this.context, input)) {
            return input;
        }
        try {
            time = new Long("" + input.get((Object)"@timestamp"));
        }
        catch (Exception e) {
            time = System.currentTimeMillis();
        }
        Statistics st = new Statistics();
        Set selected = KeyFilter.select((Data)input, (String[])this.keys);
        for (String key : selected) {
            Serializable val;
            if (key.startsWith("@") || !((val = (Serializable)input.get((Object)key)) instanceof Number)) continue;
            st.put((Object)key, (Object)((Number)val).doubleValue());
        }
        log.trace("Adding statistics at {}: {}", (Object)time, (Object)st);
        this.timeline.add(st);
        return input;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    protected boolean containsKey(String key) {
        if (this.keys == null) {
            return false;
        }
        for (String k : this.keys) {
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    public Time getHistory() {
        return this.history;
    }

    public void setHistory(Time history) {
        this.history = history;
    }

    public Time getInterval() {
        return this.interval;
    }

    public void setInterval(Time interval) {
        this.interval = interval;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }
}

