/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.dashboard.Chart;
import stream.dashboard.TimelineDatasetAdapter;
import stream.data.Statistics;
import stream.statistics.StatisticsHistory;

public class TimelineChart
extends Chart {
    static Logger log = LoggerFactory.getLogger(TimelineChart.class);
    public static final int AREA_CHART = 0;
    public static final int LINE_CHART = 1;
    Type linetype = Type.AreaChart;
    final StatisticsHistory statistics;
    final TimelineDatasetAdapter data;
    final XYPlot plot;
    AbstractXYItemRenderer renderer;

    public TimelineChart(long history, long step, Type lineType) {
        super("");
        this.statistics = new StatisticsHistory(step, history);
        this.data = new TimelineDatasetAdapter(this.statistics);
        this.linetype = lineType;
        this.plot = this.createPlot(this.data, this.statistics, ".*");
    }

    private XYPlot createPlot(TimelineDatasetAdapter dataset, StatisticsHistory stats, String filter) {
        DateAxis dateAxis = new DateAxis();
        dateAxis.setPositiveArrowVisible(true);
        dateAxis.setNegativeArrowVisible(true);
        dateAxis.setRightArrow((Shape)new Arc2D.Double(0));
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        dateAxis.setAutoRange(false);
        dateAxis.setMinorTickCount(stats.getSteps());
        dateAxis.setLabelPaint((Paint)Color.white);
        NumberAxis yAxis1 = new NumberAxis();
        yAxis1.setAutoRange(true);
        yAxis1.setRangeType(RangeType.POSITIVE);
        yAxis1.setAutoRangeIncludesZero(true);
        yAxis1.setNumberFormatOverride((NumberFormat)new DecimalFormat("0"));
        this.renderer = new XYStepAreaRenderer();
        int i = 1;
        if (i == 0) {
            this.renderer = new XYStepAreaRenderer();
        }
        if (i == 1) {
            this.renderer = new StackedXYAreaRenderer();
        }
        if (i == 2) {
            this.renderer = new StackedXYAreaRenderer2();
        }
        this.renderer = new XYLineAndShapeRenderer();
        this.renderer = new XYAreaRenderer();
        if (this.linetype == Type.LineChart) {
            XYLineAndShapeRenderer lasr = new XYLineAndShapeRenderer();
            lasr.setBaseShapesVisible(false);
            this.renderer = lasr;
        }
        if (this.linetype == Type.AreaChart) {
            this.renderer = new XYAreaRenderer();
        }
        if (this.linetype == Type.StepAreaChart) {
            this.renderer = new XYStepAreaRenderer();
        }
        if (this.linetype == Type.StackedAreaChart) {
            this.renderer = new StackedXYAreaRenderer();
        }
        this.renderer.setAutoPopulateSeriesShape(false);
        this.renderer.setAutoPopulateSeriesOutlinePaint(false);
        this.renderer.setAutoPopulateSeriesFillPaint(false);
        this.renderer.setAutoPopulateSeriesPaint(false);
        this.renderer.setBaseOutlineStroke((Stroke)new BasicStroke(1.0f));
        this.renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
        this.renderer.setBasePaint((Paint)Color.LIGHT_GRAY);
        this.renderer.setBaseOutlinePaint((Paint)Color.DARK_GRAY);
        this.renderer.setBaseItemLabelsVisible(false);
        for (int s = 0; s < 5; ++s) {
            Color c = this.getColor(s);
            this.renderer.setSeriesFillPaint(s, (Paint)c);
            this.renderer.setSeriesOutlinePaint(s, (Paint)Color.BLUE);
            this.renderer.setSeriesPaint(s, (Paint)c);
            this.renderer.setSeriesItemLabelsVisible(s, false);
            this.renderer.setSeriesShape(s, null);
        }
        try {
            if (filter != null) {
                Pattern.compile(filter);
                dataset.setSeriesFilter(filter);
            } else {
                dataset.setSeriesFilter(".*");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)new DateAxis(), (ValueAxis)yAxis1, (XYItemRenderer)this.renderer);
        plot.setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlineVisible(false);
        plot.setRenderer((XYItemRenderer)this.renderer);
        plot.setAxisOffset(new RectangleInsets(4.0, 1.0, 0.0, 0.0));
        return plot;
    }

    public void add(Statistics st) {
        this.add(System.currentTimeMillis(), st);
    }

    public void add(Long ts, Statistics st) {
        for (String key : st.keySet()) {
            int idx = this.data.seriesKeys.indexOf(key);
            if (idx >= 0) continue;
            idx = this.data.seriesKeys.size();
            Color c = this.getColor(key);
            if (c == null) {
                c = this.getColor(idx);
            }
            log.info("Color for new series '{}' will be: {}", (Object)key, (Object)c);
            this.renderer.setSeriesFillPaint(idx, (Paint)c);
            this.renderer.setSeriesOutlinePaint(idx, (Paint)c);
            this.plot.setRenderer((XYItemRenderer)this.renderer);
        }
        this.data.add(ts, st);
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public static void main(String[] args) throws Exception {
        TimelineChart chart = new TimelineChart(60000L, 1000L, Type.AreaChart);
        JFreeChart jfc = new JFreeChart((Plot)chart.plot);
        ChartPanel p = new ChartPanel(jfc);
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)p, "Center");
        frame.setSize(640, 240);
        frame.setVisible(true);
        while (true) {
            Statistics st = new Statistics("test");
            st.put((Object)"ABC", (Object)(Math.random() * 10.0));
            chart.add(st);
            log.info("Adding new data...{}", (Object)st);
            Thread.sleep(1000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LineChart,
        AreaChart,
        StepAreaChart,
        StackedAreaChart;

    }
}

