/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.TableXYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.data.Statistics;
import stream.statistics.StatisticsHistory;

public class TimelineDatasetAdapter
implements TableXYDataset {
    static Logger log = LoggerFactory.getLogger(TimelineDatasetAdapter.class);
    final List<DatasetChangeListener> listener = new LinkedList<DatasetChangeListener>();
    DatasetGroup group;
    StatisticsHistory timeline;
    LinkedList<String> seriesKeys = new LinkedList();

    public TimelineDatasetAdapter(StatisticsHistory timeline) {
        this.timeline = timeline;
        this.setSeriesFilter(".*");
    }

    public Date getStart() {
        return new Date(this.timeline.mapTimestamp(Long.valueOf(System.currentTimeMillis() - this.timeline.getStepSize())));
    }

    public Date getEnd() {
        return new Date(this.timeline.mapTimestamp(Long.valueOf(System.currentTimeMillis())));
    }

    public void setSeriesFilter(String filter) {
        this.seriesKeys.clear();
    }

    public int getItemCount() {
        int steps = this.timeline.getSteps();
        return steps;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getItemCount(int arg0) {
        int steps = this.timeline.getSteps();
        return steps;
    }

    public Number getX(int arg0, int arg1) {
        return this.getXValue(arg0, arg1);
    }

    public double getXValue(int series, int step) {
        Date date = new Date(this.timeline.getTimestamp(step));
        return date.getTime();
    }

    public Number getY(int arg0, int arg1) {
        Double val = this.getYValue(arg0, arg1);
        if (Double.isNaN(val)) {
            return null;
        }
        return val;
    }

    public double getYValue(int series, int step) {
        String key = this.seriesKeys.get(series);
        Statistics st = (Statistics)this.timeline.get(step);
        if (key == null || st == null || st.get((Object)key) == null || (Double)st.get((Object)key) == 0.0) {
            return 0.0;
        }
        Double val = (Double)st.get((Object)key);
        if (val == null) {
            return Double.NaN;
        }
        return val;
    }

    public int getSeriesCount() {
        return this.seriesKeys.size();
    }

    public Comparable getSeriesKey(int arg0) {
        return (Comparable)((Object)this.seriesKeys.get(arg0));
    }

    public int indexOf(Comparable arg0) {
        return this.seriesKeys.indexOf(arg0);
    }

    public void addChangeListener(DatasetChangeListener arg0) {
        this.listener.add(arg0);
    }

    public void removeChangeListener(DatasetChangeListener arg0) {
        this.listener.remove(arg0);
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup arg0) {
        this.group = arg0;
    }

    public void add(Statistics st) {
        this.add(System.currentTimeMillis(), st);
    }

    public void add(Long time, Statistics st) {
        this.timeline.add(time, st);
        for (String key : st.keySet()) {
            if (this.seriesKeys.contains(key)) continue;
            this.seriesKeys.add(key);
        }
        for (DatasetChangeListener l : this.listener) {
            l.datasetChanged(new DatasetChangeEvent((Object)this, (Dataset)this));
        }
    }
}

