/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.StatefulProcessor;
import stream.expressions.Condition;

public abstract class Widget
extends JPanel
implements MouseListener,
StatefulProcessor {
    private static final long serialVersionUID = 3235914639396581290L;
    static final Color ACTIVE_BORDER_COLOR = new Color(160, 160, 160);
    static final Color INACTIVE_BORDER_COLOR = new Color(224, 224, 224);
    final JLabel title = new JLabel();
    final JPanel header = new JPanel(new BorderLayout());
    protected final JPanel content = new JPanel(new BorderLayout());
    final JPanel icons = new JPanel(new FlowLayout());
    Condition condition;
    protected String titleString;
    protected ProcessContext context;

    public Widget() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.title.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.icons.add(new JButton("x"));
        this.icons.setVisible(false);
        this.header.add((Component)this.title, "West");
        this.header.add((Component)this.icons, "East");
        this.header.setBackground(new Color(239, 239, 239));
        this.header.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, INACTIVE_BORDER_COLOR));
        this.add((Component)this.header, "North");
        this.content.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.content.setBorder(null);
        this.content.setBackground(Color.WHITE);
        this.add((Component)this.content, "Center");
        this.setBorder(new LineBorder(INACTIVE_BORDER_COLOR));
        Font f = this.title.getFont().deriveFont(11.0f);
        this.title.setForeground(Color.DARK_GRAY);
        this.title.setFont(f);
        this.setSize(320, 240);
    }

    public Widget(int width, int height) {
        this();
        this.setSize(width, height);
    }

    public JPanel getHeader() {
        return this.header;
    }

    public void setTitle(String str) {
        this.title.setText(str);
        this.titleString = str;
    }

    public void setContent(Component c) {
        this.content.removeAll();
        this.content.add(c, "Center");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setBorder(new LineBorder(ACTIVE_BORDER_COLOR));
        if (e.getSource() == this.header) {
            this.icons.setVisible(true);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setBorder(new LineBorder(INACTIVE_BORDER_COLOR));
        if (e.getSource() == this.header) {
            this.icons.setVisible(false);
        }
    }

    public void highlight(boolean b) {
        if (b) {
            this.setBorder(new LineBorder(ACTIVE_BORDER_COLOR));
        } else {
            this.setBorder(new LineBorder(INACTIVE_BORDER_COLOR));
        }
    }

    public void init(ProcessContext ctx) throws Exception {
        this.context = ctx;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean handles(Data item) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.matches((Context)this.context, item);
    }

    public abstract Data process(Data var1);

    public void resetState() throws Exception {
    }

    public void finish() throws Exception {
    }
}

