/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.dashboard.Dashboard;
import stream.dashboard.Widget;

public class WidgetMover
extends MouseAdapter {
    static Logger log = LoggerFactory.getLogger(WidgetMover.class);
    final Dashboard dashboard;
    int gridx = 25;
    int gridy = 25;
    int offx = 0;
    int offy = 0;
    Widget selected = null;

    public WidgetMover(Dashboard dashboard) {
        this.dashboard = dashboard;
        this.gridx = dashboard.gridSize();
        this.gridy = dashboard.gridSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseMoved(MouseEvent e) {
        Component c = this.dashboard.display.getComponentAt(e.getPoint());
        if (c != null && c instanceof Widget) {
            Widget w = (Widget)c;
            w.highlight(true);
            this.dashboard.setCursor(Cursor.getPredefinedCursor(13));
            if (!w.getHeader().contains(e.getPoint())) return;
        }
        this.dashboard.setCursor(Cursor.getDefaultCursor());
        for (Widget w : this.dashboard.getWidgets()) {
            w.highlight(false);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.selected = null;
        this.dashboard.message(null);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.selected != null) {
            int x = e.getX() + this.offx;
            int y = e.getY() + this.offy;
            x = this.gridx + x - x % this.gridx;
            y = this.gridy + y - y % this.gridy;
            this.selected.setLocation(x, y);
            this.dashboard.message("( " + this.selected.getLocation().x + " | " + this.selected.getLocation().y + " )");
            return;
        }
    }

    public void mousePressed(MouseEvent e) {
        Component c = this.dashboard.display.getComponentAt(e.getPoint());
        if (c != null && c instanceof Widget) {
            this.selected = (Widget)c;
            this.offx = this.selected.getX() - e.getX();
            this.offy = this.selected.getY() - e.getY();
            return;
        }
    }
}

