/*
 * Decompiled with CFR 0.152.
 */
package stream.dashboard.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.dashboard.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRenderer
extends DefaultListCellRenderer {
    static Logger log = LoggerFactory.getLogger(MessageRenderer.class);
    private static final long serialVersionUID = 6075399482778842473L;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    final SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
    final Font dateTimeFont = new JLabel().getFont().deriveFont(10.0f);

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
        Message value = (Message)obj;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.setBackground(Color.WHITE);
        JPanel datePanel = new JPanel();
        datePanel.setBackground(Color.WHITE);
        datePanel.setLayout(new BoxLayout(datePanel, 3));
        datePanel.setAlignmentX(0.5f);
        JLabel dateLabel = new JLabel(this.dateFormat.format(value.getTime()));
        dateLabel.setFont(this.dateTimeFont);
        dateLabel.setForeground(new Color(4, 4, 4));
        dateLabel.setAlignmentX(0.5f);
        JLabel timeLabel = new JLabel(this.timeFormat.format(value.getTime()));
        timeLabel.setFont(this.dateTimeFont);
        timeLabel.setForeground(new Color(4, 4, 4));
        timeLabel.setAlignmentX(0.5f);
        datePanel.add(dateLabel);
        datePanel.add(timeLabel);
        JLabel text = new JLabel();
        text.setText(value.getText());
        text.setFont(this.dateTimeFont);
        text.setForeground(new Color(4, 4, 4));
        text.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)datePanel, "West");
        panel.add((Component)text, "Center");
        log.info("Returning list-cell-renderer {}", (Object)panel);
        return panel;
    }
}

