/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.dashboard.DataListener;
import stream.io.JSONStream;

public class JSONReceiver
extends Thread
implements DataListener {
    static Logger log = LoggerFactory.getLogger(JSONReceiver.class);
    List<DataListener> listener = new ArrayList<DataListener>();
    List<ClientHandler> clients = new ArrayList<ClientHandler>();
    final String address;
    final int port;
    ServerSocket socket;

    public JSONReceiver(String addr, int port) {
        this.address = addr;
        this.port = port;
    }

    public void run() {
        try {
            this.socket = new ServerSocket(this.port, 1000, InetAddress.getByName(this.address));
            while (true) {
                log.info("Waiting for clients to connect...");
                Socket client = this.socket.accept();
                ClientHandler handler = new ClientHandler(client, this);
                log.info("Client connected from {}, starting handler...", (Object)client.getRemoteSocketAddress());
                handler.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void dataArrived(Data item) {
        for (DataListener l : this.listener) {
            l.dataArrived(item);
        }
    }

    public void registerListener(DataListener l) {
        this.listener.add(l);
    }

    public static class ClientHandler
    extends Thread {
        final JSONReceiver listener;
        final Socket client;

        public ClientHandler(Socket client, JSONReceiver l) {
            this.listener = l;
            this.client = client;
        }

        public void run() {
            try {
                JSONStream stream = new JSONStream(this.client.getInputStream());
                stream.init();
                Data item = stream.read();
                while (item != null) {
                    this.listener.dataArrived(item);
                    item = stream.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

