/*
 * Decompiled with CFR 0.152.
 */
package org.jzenith.example;

import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.TracerR;
import io.opentracing.contrib.reporter.slf4j.Slf4jReporter;
import io.opentracing.noop.NoopTracerFactory;
import javax.sql.DataSource;
import org.jzenith.core.AbstractPlugin;
import org.jzenith.core.JZenith;
import org.jzenith.example.mapper.MapperModule;
import org.jzenith.example.persistence.PersistenceLayerModule;
import org.jzenith.example.resources.HelloWorldResource;
import org.jzenith.example.resources.UserResource;
import org.jzenith.example.service.ServiceLayerModule;
import org.jzenith.example.service.exception.NoSuchUserThrowable;
import org.jzenith.jdbc.JdbcDatabaseType;
import org.jzenith.jdbc.JdbcPlugin;
import org.jzenith.rest.RestPlugin;
import org.jzenith.rest.tracing.RequestScopedScopeManager;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.LoggerFactory;

public class PostgresJdbcExampleApp {
    private static JZenith application;

    public static void main(String ... args) {
        application = PostgresJdbcExampleApp.configureApplication(args).run();
    }

    public static JZenith configureApplication(String ... args) {
        PGSimpleDataSource dataSource = PostgresJdbcExampleApp.createDataSource();
        return JZenith.application((String[])args).withTracer((Tracer)new TracerR((Tracer)NoopTracerFactory.create(), (Reporter)new Slf4jReporter(LoggerFactory.getLogger((String)"opentracing"), true), (ScopeManager)new RequestScopedScopeManager())).withPlugins(new AbstractPlugin[]{RestPlugin.withResources((Class[])new Class[]{HelloWorldResource.class, UserResource.class}).withMapping(NoSuchUserThrowable.class, 404), JdbcPlugin.create((DataSource)dataSource, (JdbcDatabaseType)JdbcDatabaseType.POSTGRES)}).withModules(new Module[]{new ServiceLayerModule(), new PersistenceLayerModule(), new MapperModule()});
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"})
    private static PGSimpleDataSource createDataSource() {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setPortNumber(5433);
        dataSource.setServerName("localhost");
        dataSource.setDatabaseName("test");
        dataSource.setUser("test");
        dataSource.setPassword("test");
        return dataSource;
    }

    public static void stop() {
        application.stop();
    }
}

