/*
 * Decompiled with CFR 0.152.
 */
package org.jzenith.example.persistence.impl;

import com.google.common.collect.ImmutableList;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import lombok.NonNull;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.InsertValuesStep2;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentAfterOffsetStep;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.jzenith.example.persistence.UserDao;
import org.jzenith.example.persistence.impl.Users;
import org.jzenith.example.persistence.model.Deleted;
import org.jzenith.example.persistence.model.Updated;
import org.jzenith.example.service.model.User;
import org.jzenith.jdbc.JdbcClient;
import org.jzenith.jdbc.model.Row;
import org.jzenith.rest.model.Page;

public class UserDaoImpl
implements UserDao {
    private final JdbcClient client;
    private final DSLContext dslContext;

    @Inject
    public UserDaoImpl(JdbcClient client, DSLContext dslContext) {
        this.client = client;
        this.dslContext = dslContext;
    }

    public Single<User> save(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked @NonNull but is null");
        }
        InsertValuesStep2 insert = this.dslContext.insertInto(Users.USERS_TABLE).columns(Users.ID_FIELD, Users.NAME_FIELD).values((Object)user.getId(), (Object)user.getName());
        return this.client.executeInsert((Query)insert).andThen((SingleSource)Single.just((Object)user));
    }

    public Maybe<User> getById(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        SelectConditionStep select = this.dslContext.select(Users.ID_FIELD, Users.NAME_FIELD).from(Users.USERS_TABLE).where(Users.ID_FIELD.eq((Object)id));
        return this.client.executeForSingleRow((Query)select).map(this::toUser);
    }

    public Single<Updated> updateNameById(@NonNull UUID id, @NonNull String name) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        UpdateConditionStep update = this.dslContext.update(Users.USERS_TABLE).set(Users.NAME_FIELD, (Object)name).where(Users.ID_FIELD.eq((Object)id));
        return this.client.executeForRowCount((Query)update).map(count -> count > 0 ? Updated.YES : Updated.NO);
    }

    public Single<Page<User>> listUsers(@NonNull Integer offset, @NonNull Integer limit) {
        if (offset == null) {
            throw new NullPointerException("offset is marked @NonNull but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked @NonNull but is null");
        }
        SelectLimitPercentAfterOffsetStep select = this.dslContext.select(Users.ID_FIELD, Users.NAME_FIELD).from(Users.USERS_TABLE).orderBy((OrderField)Users.NAME_FIELD.asc()).offset(offset.intValue()).limit(limit.intValue());
        SelectJoinStep count = this.dslContext.select((SelectField)DSL.count()).from(Users.USERS_TABLE);
        return Single.zip((SingleSource)this.client.executeForSingleRow((Query)count).toSingle(), (SingleSource)this.client.stream((Query)select).toList(), (countRow, valueRows) -> new Page(offset.intValue(), limit.intValue(), countRow.getOnlyLong().longValue(), this.mapToUsers((List<Row>)valueRows)));
    }

    public Single<Deleted> deleteById(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        DeleteConditionStep delete = this.dslContext.deleteFrom(Users.USERS_TABLE).where(Users.ID_FIELD.eq((Object)id));
        return this.client.executeForRowCount((Query)delete).map(count -> count > 0 ? Deleted.YES : Deleted.NO);
    }

    private List<User> mapToUsers(List<Row> valueRows) {
        return (List)valueRows.stream().map(this::toUser).collect(ImmutableList.toImmutableList());
    }

    private User toUser(Row row) {
        return new User(row.getUUID(Users.ID_FIELD.getName()), row.getString(Users.NAME_FIELD.getName()));
    }
}

