/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.http;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.http.GatewayHttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpInjectableHeader;
import org.kaazing.gateway.resource.address.http.HttpOriginSecurity;
import org.kaazing.gateway.security.LoginContextFactory;

public final class HttpResourceAddress
extends ResourceAddress {
    private static final long serialVersionUID = 1L;
    static final String TRANSPORT_NAME = "http";
    public static final ResourceOption<Boolean> KEEP_ALIVE = new HttpKeepAliveOption();
    public static final ResourceOption<Integer> KEEP_ALIVE_TIMEOUT = new HttpKeepAliveTimeoutOption();
    public static final ResourceOption<String> REALM_NAME = new HttpRealmNameOption();
    public static final ResourceOption<String> REALM_AUTHORIZATION_MODE = new HttpRealmAuthorizationModeOption();
    public static final ResourceOption<String> REALM_CHALLENGE_SCHEME = new HttpRealmChallengeSchemeOption();
    public static final ResourceOption<String> REALM_DESCRIPTION = new HttpRealmDescriptionOption();
    public static final ResourceOption<String[]> REALM_AUTHENTICATION_HEADER_NAMES = new HttpRealmAuthenticationHeaderNamesOption();
    public static final ResourceOption<String[]> REALM_AUTHENTICATION_PARAMETER_NAMES = new HttpRealmAuthenticationParameterNamesOption();
    public static final ResourceOption<String[]> REALM_AUTHENTICATION_COOKIE_NAMES = new HttpRealmAuthenticationCookieNamesOption();
    public static final ResourceOption<LoginContextFactory> LOGIN_CONTEXT_FACTORY = new HttpLoginContextFactoryOption();
    public static final ResourceOption<String[]> REQUIRED_ROLES = new HttpRequiredRolesOption();
    public static final ResourceOption<Set<HttpInjectableHeader>> INJECTABLE_HEADERS = new HttpInjectableHeadersOption();
    public static final ResourceOption<HttpOriginSecurity> ORIGIN_SECURITY = new HttpOriginSecurityOption();
    public static final ResourceOption<File> TEMP_DIRECTORY = new HttpTempDirectoryOption();
    public static final ResourceOption<GatewayHttpOriginSecurity> GATEWAY_ORIGIN_SECURITY = new GatewayHttpOriginSecurityOption();
    public static final ResourceOption<Collection<URI>> BALANCE_ORIGINS = new HttpBalanceOriginsOption();
    public static final ResourceOption<String> AUTHENTICATION_CONNECT = new AuthenticationConnectOption();
    public static final ResourceOption<String> AUTHENTICATION_IDENTIFIER = new AuthenticationIdentifierOption();
    public static final ResourceOption<String> ENCRYPTION_KEY_ALIAS = new EncryptionKeyAliasOption();
    public static final ResourceOption<String> SERVICE_DOMAIN = new ServiceDomainOption();
    private Boolean keepAlive = (Boolean)KEEP_ALIVE.defaultValue();
    private Integer keepAliveTimeout = (Integer)KEEP_ALIVE_TIMEOUT.defaultValue();
    private String[] requiredRoles = (String[])REQUIRED_ROLES.defaultValue();
    private String realmName;
    private String realmAuthorizationMode = (String)REALM_AUTHORIZATION_MODE.defaultValue();
    private String realmChallengeScheme;
    private String realmDescription;
    private String[] realmAuthenticationHeaderNames;
    private String[] realmAuthenticationParameterNames;
    private String[] realmAuthenticationCookieNames;
    private LoginContextFactory loginContextFactory;
    private Set<HttpInjectableHeader> injectableHeaders = (Set)INJECTABLE_HEADERS.defaultValue();
    private HttpOriginSecurity originSecurity;
    private File tempDirectory;
    private GatewayHttpOriginSecurity gatewayOriginSecurity;
    private Collection<URI> balanceOrigins;
    private String authenticationConnect;
    private String authenticationIdentifier;
    private String encryptionKeyAlias;
    private String serviceDomain;

    HttpResourceAddress(URI original, URI resource) {
        super(original, resource);
    }

    protected <V> V getOption0(ResourceOption<V> option) {
        if (option instanceof HttpResourceOption) {
            HttpResourceOption httpOption = (HttpResourceOption)option;
            switch (httpOption.kind) {
                case KEEP_ALIVE: {
                    return (V)this.keepAlive;
                }
                case KEEP_ALIVE_TIMEOUT: {
                    return (V)this.keepAliveTimeout;
                }
                case REQUIRED_ROLES: {
                    return (V)this.requiredRoles;
                }
                case REALM_NAME: {
                    return (V)this.realmName;
                }
                case REALM_AUTHORIZATION_MODE: {
                    return (V)this.realmAuthorizationMode;
                }
                case REALM_CHALLENGE_SCHEME: {
                    return (V)this.realmChallengeScheme;
                }
                case REALM_DESCRIPTION: {
                    return (V)this.realmDescription;
                }
                case REALM_AUTHENTICATION_HEADER_NAMES: {
                    return (V)this.realmAuthenticationHeaderNames;
                }
                case REALM_AUTHENTICATION_PARAMETER_NAMES: {
                    return (V)this.realmAuthenticationParameterNames;
                }
                case REALM_AUTHENTICATION_COOKIE_NAMES: {
                    return (V)this.realmAuthenticationCookieNames;
                }
                case LOGIN_CONTEXT_FACTORY: {
                    return (V)this.loginContextFactory;
                }
                case INJECTABLE_HEADERS: {
                    return (V)this.injectableHeaders;
                }
                case ORIGIN_SECURITY: {
                    return (V)this.originSecurity;
                }
                case TEMP_DIRECTORY: {
                    return (V)this.tempDirectory;
                }
                case GATEWAY_ORIGIN_SECURITY: {
                    return (V)this.gatewayOriginSecurity;
                }
                case BALANCE_ORIGINS: {
                    return (V)this.balanceOrigins;
                }
                case AUTHENTICATION_CONNECT: {
                    return (V)this.authenticationConnect;
                }
                case AUTHENTICATION_IDENTIFIER: {
                    return (V)this.authenticationIdentifier;
                }
                case ENCRYPTION_KEY_ALIAS: {
                    return (V)this.encryptionKeyAlias;
                }
                case SERVICE_DOMAIN: {
                    return (V)this.serviceDomain;
                }
            }
        }
        return (V)super.getOption0(option);
    }

    protected <V> void setOption0(ResourceOption<V> option, V value) {
        if (option instanceof HttpResourceOption) {
            HttpResourceOption httpOption = (HttpResourceOption)option;
            switch (httpOption.kind) {
                case KEEP_ALIVE: {
                    this.keepAlive = (Boolean)value;
                    return;
                }
                case KEEP_ALIVE_TIMEOUT: {
                    this.keepAliveTimeout = (Integer)value;
                    return;
                }
                case REQUIRED_ROLES: {
                    this.requiredRoles = (String[])value;
                    return;
                }
                case REALM_NAME: {
                    this.realmName = (String)value;
                    return;
                }
                case REALM_AUTHORIZATION_MODE: {
                    this.realmAuthorizationMode = (String)value;
                    return;
                }
                case REALM_CHALLENGE_SCHEME: {
                    this.realmChallengeScheme = (String)value;
                    return;
                }
                case REALM_DESCRIPTION: {
                    this.realmDescription = (String)value;
                    return;
                }
                case REALM_AUTHENTICATION_HEADER_NAMES: {
                    this.realmAuthenticationHeaderNames = (String[])value;
                    return;
                }
                case REALM_AUTHENTICATION_PARAMETER_NAMES: {
                    this.realmAuthenticationParameterNames = (String[])value;
                    return;
                }
                case REALM_AUTHENTICATION_COOKIE_NAMES: {
                    this.realmAuthenticationCookieNames = (String[])value;
                    return;
                }
                case LOGIN_CONTEXT_FACTORY: {
                    this.loginContextFactory = (LoginContextFactory)value;
                    return;
                }
                case AUTHENTICATION_CONNECT: {
                    this.authenticationConnect = (String)value;
                    return;
                }
                case AUTHENTICATION_IDENTIFIER: {
                    this.authenticationIdentifier = (String)value;
                    return;
                }
                case ENCRYPTION_KEY_ALIAS: {
                    this.encryptionKeyAlias = (String)value;
                    return;
                }
                case SERVICE_DOMAIN: {
                    this.serviceDomain = (String)value;
                    return;
                }
                case INJECTABLE_HEADERS: {
                    this.injectableHeaders = (Set)value;
                    return;
                }
                case ORIGIN_SECURITY: {
                    this.originSecurity = (HttpOriginSecurity)value;
                    return;
                }
                case TEMP_DIRECTORY: {
                    this.tempDirectory = (File)value;
                    return;
                }
                case GATEWAY_ORIGIN_SECURITY: {
                    this.gatewayOriginSecurity = (GatewayHttpOriginSecurity)value;
                    return;
                }
                case BALANCE_ORIGINS: {
                    this.balanceOrigins = (Collection)value;
                    return;
                }
            }
        }
        super.setOption0(option, value);
    }

    private static final class ServiceDomainOption
    extends HttpResourceOption<String> {
        private ServiceDomainOption() {
            super(HttpResourceOption.Kind.SERVICE_DOMAIN, "serviceDomain");
        }
    }

    private static final class EncryptionKeyAliasOption
    extends HttpResourceOption<String> {
        private EncryptionKeyAliasOption() {
            super(HttpResourceOption.Kind.ENCRYPTION_KEY_ALIAS, "encryptionKeyAlias");
        }
    }

    private static final class AuthenticationIdentifierOption
    extends HttpResourceOption<String> {
        private AuthenticationIdentifierOption() {
            super(HttpResourceOption.Kind.AUTHENTICATION_IDENTIFIER, "authenticationIdentifier");
        }
    }

    private static final class AuthenticationConnectOption
    extends HttpResourceOption<String> {
        private AuthenticationConnectOption() {
            super(HttpResourceOption.Kind.AUTHENTICATION_CONNECT, "authenticationConnect");
        }
    }

    private static final class HttpBalanceOriginsOption
    extends HttpResourceOption<Collection<URI>> {
        private HttpBalanceOriginsOption() {
            super(HttpResourceOption.Kind.BALANCE_ORIGINS, "balanceOrigins");
        }
    }

    private static final class GatewayHttpOriginSecurityOption
    extends HttpResourceOption<GatewayHttpOriginSecurity> {
        private GatewayHttpOriginSecurityOption() {
            super(HttpResourceOption.Kind.GATEWAY_ORIGIN_SECURITY, "gatewayHttpOriginSecurity");
        }
    }

    private static final class HttpTempDirectoryOption
    extends HttpResourceOption<File> {
        private HttpTempDirectoryOption() {
            super(HttpResourceOption.Kind.TEMP_DIRECTORY, "tempDirectory");
        }
    }

    private static final class HttpOriginSecurityOption
    extends HttpResourceOption<HttpOriginSecurity> {
        private HttpOriginSecurityOption() {
            super(HttpResourceOption.Kind.ORIGIN_SECURITY, "originSecurity");
        }
    }

    private static final class HttpInjectableHeadersOption
    extends HttpResourceOption<Set<HttpInjectableHeader>> {
        private HttpInjectableHeadersOption() {
            super(HttpResourceOption.Kind.INJECTABLE_HEADERS, "injectableHeaders", EnumSet.allOf(HttpInjectableHeader.class));
        }
    }

    private static final class HttpLoginContextFactoryOption
    extends HttpResourceOption<LoginContextFactory> {
        private HttpLoginContextFactoryOption() {
            super(HttpResourceOption.Kind.LOGIN_CONTEXT_FACTORY, "loginContextFactory");
        }
    }

    private static final class HttpRealmDescriptionOption
    extends HttpResourceOption<String> {
        private HttpRealmDescriptionOption() {
            super(HttpResourceOption.Kind.REALM_DESCRIPTION, "realmDescription");
        }
    }

    private static final class HttpRealmAuthenticationCookieNamesOption
    extends HttpResourceOption<String[]> {
        private HttpRealmAuthenticationCookieNamesOption() {
            super(HttpResourceOption.Kind.REALM_AUTHENTICATION_COOKIE_NAMES, "realmAuthenticationCookieNames", new String[0]);
        }
    }

    private static final class HttpRealmAuthenticationParameterNamesOption
    extends HttpResourceOption<String[]> {
        private HttpRealmAuthenticationParameterNamesOption() {
            super(HttpResourceOption.Kind.REALM_AUTHENTICATION_PARAMETER_NAMES, "realmAuthenticationParameterNames", new String[0]);
        }
    }

    private static final class HttpRealmAuthenticationHeaderNamesOption
    extends HttpResourceOption<String[]> {
        private HttpRealmAuthenticationHeaderNamesOption() {
            super(HttpResourceOption.Kind.REALM_AUTHENTICATION_HEADER_NAMES, "realmAuthenticationHeaderNames", new String[0]);
        }
    }

    private static final class HttpRealmChallengeSchemeOption
    extends HttpResourceOption<String> {
        private HttpRealmChallengeSchemeOption() {
            super(HttpResourceOption.Kind.REALM_CHALLENGE_SCHEME, "realmChallengeScheme");
        }
    }

    private static final class HttpRealmAuthorizationModeOption
    extends HttpResourceOption<String> {
        private HttpRealmAuthorizationModeOption() {
            super(HttpResourceOption.Kind.REALM_AUTHORIZATION_MODE, "realmAuthorizationMode", "challenge");
        }
    }

    private static final class HttpRealmNameOption
    extends HttpResourceOption<String> {
        private HttpRealmNameOption() {
            super(HttpResourceOption.Kind.REALM_NAME, "realmName");
        }
    }

    private static final class HttpRequiredRolesOption
    extends HttpResourceOption<String[]> {
        private HttpRequiredRolesOption() {
            super(HttpResourceOption.Kind.REQUIRED_ROLES, "requiredRoles", new String[0]);
        }
    }

    private static final class HttpKeepAliveOption
    extends HttpResourceOption<Boolean> {
        private HttpKeepAliveOption() {
            super(HttpResourceOption.Kind.KEEP_ALIVE, "keepAlive", Boolean.TRUE);
        }
    }

    private static final class HttpKeepAliveTimeoutOption
    extends HttpResourceOption<Integer> {
        private HttpKeepAliveTimeoutOption() {
            super(HttpResourceOption.Kind.KEEP_ALIVE_TIMEOUT, "keepAliveTimeout", 30);
        }
    }

    static class HttpResourceOption<T>
    extends ResourceOption<T> {
        private static final Map<String, ResourceOption<?>> OPTION_NAMES = new HashMap();
        private final Kind kind;

        private HttpResourceOption(Kind kind, String name) {
            this(kind, name, null);
        }

        private HttpResourceOption(Kind kind, String name, T defaultValue) {
            super(OPTION_NAMES, name, defaultValue);
            this.kind = kind;
        }

        protected static enum Kind {
            KEEP_ALIVE,
            KEEP_ALIVE_TIMEOUT,
            REQUIRED_ROLES,
            REALM_NAME,
            REALM_AUTHORIZATION_MODE,
            REALM_CHALLENGE_SCHEME,
            REALM_DESCRIPTION,
            REALM_AUTHENTICATION_HEADER_NAMES,
            REALM_AUTHENTICATION_PARAMETER_NAMES,
            REALM_AUTHENTICATION_COOKIE_NAMES,
            LOGIN_CONTEXT_FACTORY,
            INJECTABLE_HEADERS,
            ORIGIN_SECURITY,
            TEMP_DIRECTORY,
            GATEWAY_ORIGIN_SECURITY,
            BALANCE_ORIGINS,
            AUTHENTICATION_CONNECT,
            AUTHENTICATION_IDENTIFIER,
            ENCRYPTION_KEY_ALIAS,
            SERVICE_DOMAIN;

        }
    }
}

