/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.sse;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.sse.SseResourceAddress;

public class SseResourceAddressFactorySpi
extends ResourceAddressFactorySpi<SseResourceAddress> {
    private static final String SCHEME_NAME = "sse";
    private static final int SCHEME_PORT = 80;
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.changeSchemeOnly((String)"http");
    private static final ResourceFactory SSE_HTTPXE_RESOURCE_FACTORY = ResourceFactories.changeSchemeOnly((String)"sse+httpxe");

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    protected int getSchemePort() {
        return 80;
    }

    protected String getTransportName() {
        return SCHEME_NAME;
    }

    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    protected String getProtocolName() {
        return null;
    }

    protected SseResourceAddress newResourceAddress0(URI original, URI location) {
        String host = location.getHost();
        int port = location.getPort();
        String path = location.getPath();
        if (host == null) {
            throw new IllegalArgumentException(String.format("Missing host in URI: %s", location));
        }
        if (port == -1) {
            throw new IllegalArgumentException(String.format("Missing port in URI: %s", location));
        }
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException(String.format("Missing path in URI: %s", location));
        }
        return new SseResourceAddress(this, original, location);
    }

    protected void setAlternateOption(URI location, ResourceOptions options, Map<String, Object> optionsByName) {
        location = SSE_HTTPXE_RESOURCE_FACTORY.createURI(location);
        optionsByName = new HashMap<String, Object>(optionsByName);
        ResourceAddress alternateAddress = this.getResourceAddressFactory().newResourceAddress(location, optionsByName);
        options.setOption(ResourceAddress.ALTERNATE, (Object)alternateAddress);
    }
}

