/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.sse;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceFactories;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.sse.SseHttpxeSslResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.sse.SseResourceAddressFactorySpi;

public class SseSslResourceAddressFactorySpi
extends SseResourceAddressFactorySpi {
    private static final String SCHEME_NAME = "sse+ssl";
    private static final int SCHEME_PORT = 443;
    private static final ResourceFactory TRANSPORT_FACTORY = ResourceFactories.changeSchemeOnly((String)"https");

    @Override
    public String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected int getSchemePort() {
        return 443;
    }

    @Override
    protected ResourceFactory getTransportFactory() {
        return TRANSPORT_FACTORY;
    }

    @Override
    protected void setAlternateOption(URI location, ResourceOptions options, Map<String, Object> optionsByName) {
        location = SseHttpxeSslResourceAddressFactorySpi.SSE_HTTPXE_RESOURCE_FACTORY.createURI(location);
        optionsByName = new HashMap<String, Object>(optionsByName);
        ResourceAddress alternateAddress = this.getResourceAddressFactory().newResourceAddress(location, optionsByName);
        options.setOption(ResourceAddress.ALTERNATE, (Object)alternateAddress);
    }
}

