/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.server.config.parse;

public enum GatewayConfigNamespace {
    DRAGONFIRE,
    EXCALIBUR,
    MARCH_2012,
    AUGUST_2012,
    SEPTEMBER_2012,
    SEPTEMBER_2014,
    CURRENT_NS;

    private static final String NS_DRAGONFIRE_URI = "http://xmlns.kaazing.com/gateway-config/dragonfire";
    private static final String NS_EXCALIBUR_URI = "http://xmlns.kaazing.com/gateway-config/excalibur";
    private static final String NS_MARCH_2012_URI = "http://xmlns.kaazing.com/2012/03/gateway";
    private static final String NS_AUGUST_2012_URI = "http://xmlns.kaazing.com/2012/08/gateway";
    private static final String NS_SEPTEMBER_2012_URI = "http://xmlns.kaazing.com/2012/09/gateway";
    private static final String NS_SEPTEMBER_2014_URI = "http://xmlns.kaazing.org/2014/09/gateway";
    private static final String NS_NOVEMBER_2015_URI = "http://xmlns.kaazing.org/2015/11/gateway";

    public static GatewayConfigNamespace fromURI(String nsURI) {
        if (nsURI == null) {
            throw new NullPointerException(nsURI);
        }
        if (nsURI.equalsIgnoreCase(NS_DRAGONFIRE_URI)) {
            return DRAGONFIRE;
        }
        if (nsURI.equalsIgnoreCase(NS_EXCALIBUR_URI)) {
            return EXCALIBUR;
        }
        if (nsURI.equalsIgnoreCase(NS_MARCH_2012_URI)) {
            return MARCH_2012;
        }
        if (nsURI.equalsIgnoreCase(NS_AUGUST_2012_URI)) {
            return AUGUST_2012;
        }
        if (nsURI.equalsIgnoreCase(NS_SEPTEMBER_2012_URI)) {
            return SEPTEMBER_2012;
        }
        if (nsURI.equalsIgnoreCase(NS_SEPTEMBER_2014_URI)) {
            return SEPTEMBER_2014;
        }
        if (nsURI.equalsIgnoreCase(NS_NOVEMBER_2015_URI)) {
            return CURRENT_NS;
        }
        throw new IllegalArgumentException(String.format("Unknown/unsupported XML namespace URI '%s'", nsURI));
    }

    public String toURI() {
        String uri = "<Unknown namespace>";
        switch (this) {
            case DRAGONFIRE: {
                uri = NS_DRAGONFIRE_URI;
                break;
            }
            case EXCALIBUR: {
                uri = NS_EXCALIBUR_URI;
                break;
            }
            case MARCH_2012: {
                uri = NS_MARCH_2012_URI;
                break;
            }
            case AUGUST_2012: {
                uri = NS_AUGUST_2012_URI;
                break;
            }
            case SEPTEMBER_2012: {
                uri = NS_SEPTEMBER_2012_URI;
                break;
            }
            case SEPTEMBER_2014: {
                uri = NS_SEPTEMBER_2014_URI;
                break;
            }
            case CURRENT_NS: {
                uri = NS_NOVEMBER_2015_URI;
            }
        }
        return uri;
    }
}

