/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.util.file.FileUtils;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

class HttpDirectoryServiceHandler
extends IoHandlerAdapter<HttpAcceptSession> {
    private ServiceContext serviceContext;
    private File baseDir;
    private String welcomeFile;
    private File errorPagesDir;
    private boolean indexes;

    HttpDirectoryServiceHandler() {
    }

    ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    File getBaseDir() {
        return this.baseDir;
    }

    void setWelcomeFile(String welcomeFile) {
        this.welcomeFile = welcomeFile;
    }

    String getWelcomeFile() {
        return this.welcomeFile;
    }

    void setErrorPagesDir(File errorPagesDir) {
        this.errorPagesDir = errorPagesDir;
    }

    boolean usingIndexes() {
        return this.indexes;
    }

    void setIndexes(boolean indexes) {
        this.indexes = indexes;
    }

    public void doSessionCreated(HttpAcceptSession session) throws Exception {
    }

    public void doSessionClosed(HttpAcceptSession session) throws Exception {
    }

    protected void doExceptionCaught(HttpAcceptSession session, Throwable cause) throws Exception {
        session.close(true);
    }

    protected void doSessionOpened(HttpAcceptSession session) throws Exception {
        String requestPath;
        HttpMethod method = session.getMethod();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD) {
            this.reportError(session, HttpStatus.CLIENT_METHOD_NOT_ALLOWED);
            session.close(false);
            return;
        }
        String pathInfo = session.getPathInfo().getPath();
        File requestFile = new File(this.baseDir, "/" + pathInfo);
        if (requestFile.isDirectory() && !(requestPath = session.getRequestURI().getPath()).endsWith("/")) {
            session.setStatus(HttpStatus.REDIRECT_FOUND);
            session.setWriteHeader("Location", requestPath + "/");
            session.close(false);
            return;
        }
        boolean underBaseDir = false;
        File baseDirCannonical = this.baseDir.getCanonicalFile();
        for (File candidate = requestFile.getCanonicalFile(); candidate != null; candidate = candidate.getParentFile()) {
            if (!candidate.equals(baseDirCannonical)) continue;
            underBaseDir = true;
            break;
        }
        if (!underBaseDir) {
            this.reportError(session, HttpStatus.CLIENT_BAD_REQUEST);
            session.close(false);
            return;
        }
        if (requestFile.isDirectory()) {
            File testWelcomeFile;
            boolean generateIndex = this.usingIndexes();
            if (this.welcomeFile != null && ((testWelcomeFile = new File(requestFile, this.welcomeFile)).exists() || !generateIndex)) {
                requestFile = testWelcomeFile;
                generateIndex = false;
            }
            if (generateIndex) {
                session.setWriteHeader("Content-Type", "text/html");
                ByteBuffer nioBuf = DirectoryListingUtils.createDirectoryListing(pathInfo, this.baseDir, requestFile);
                IoBufferAllocatorEx allocator = session.getBufferAllocator();
                IoBufferEx buf = allocator.wrap(nioBuf);
                session.write((Object)buf);
                session.close(false);
                return;
            }
        }
        if (!requestFile.exists()) {
            this.reportError(session, HttpStatus.CLIENT_NOT_FOUND);
            session.close(false);
            return;
        }
        String etag = HttpUtils.getETagHeaderValue((File)requestFile);
        boolean modified = HttpUtils.hasBeenModified((HttpSession)session, (String)etag, (File)requestFile);
        if (!modified) {
            session.setWriteHeader("ETag", etag);
            session.setStatus(HttpStatus.REDIRECT_NOT_MODIFIED);
            session.close(false);
            return;
        }
        HttpUtils.addLastModifiedHeader((HttpSession)session, (File)requestFile);
        HttpUtils.addExpiresHeader((HttpSession)session);
        session.setWriteHeader("ETag", etag);
        String contentType = this.serviceContext.getContentType(FileUtils.getFileExtension((File)requestFile));
        if (contentType != null) {
            session.setWriteHeader("Content-Type", contentType);
        }
        IoBufferAllocatorEx allocator = session.getBufferAllocator();
        IoBufferEx buf = HttpUtils.getBufferForFile((IoBufferAllocatorEx)allocator, (File)requestFile);
        session.setWriteHeader("Content-Length", Integer.toString(buf.remaining()));
        session.write((Object)buf);
        session.close(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpDirectoryServiceHandler [baseDir=").append(this.baseDir);
        if (this.welcomeFile != null) {
            sb.append(",welcomeFile=").append(this.welcomeFile);
        }
        if (this.errorPagesDir != null) {
            sb.append(",errorPagesDir=").append(this.errorPagesDir);
        }
        sb.append("]");
        return sb.toString();
    }

    private void reportError(HttpAcceptSession session, HttpStatus status) throws IOException {
        String errorFileName;
        File errorContentFile;
        session.setStatus(status);
        if (this.errorPagesDir != null && this.errorPagesDir.exists() && (errorContentFile = new File(this.errorPagesDir, errorFileName = Integer.toString(status.code()) + ".html")).exists() && errorContentFile.canRead()) {
            IoBufferAllocatorEx allocator = session.getBufferAllocator();
            IoBufferEx buf = HttpUtils.getBufferForFile((IoBufferAllocatorEx)allocator, (File)errorContentFile);
            session.setWriteHeader("Content-Length", Integer.toString(buf.remaining()));
            session.write((Object)buf);
        }
    }

    static class DirectoryListingUtils {
        private static final String[] SIZE_UNITS = new String[]{" bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB"};
        private static final String HEADER_BOILERPLATE = "<!DOCTYPE HTML><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/><title>Directory listing for ";
        private static final String BODY_BOILERPLATE = "</title></head><body><h1>Index of ";
        private static final String TABLE_BOILERPLATE = "<table><thead><tr><th>Filename</th><th class=\"number\">Size</th><th class=\"date\">Last Modified Date</th></tr></thead><tbody>";
        private static final String FOOTER_BOILERPLATE = "</tbody></table><address>Powered by Kaazing WebSocket Gateway</address></body></html>";
        private static final String STYLE_BOILERPLATE = "</h1><style type=\"text/css\">\n\nbody {\n    font-family: Arial, Helvetica, sans-serif;\n}\n\na {\n    color: #ff6600;\n    text-decoration: none;\n}\n\na:hover {\n    text-decoration: underline;\n}\n\ntable {\n    border-spacing: 0px;\n    border-bottom: solid 1px #fcdac2;\n}\n\nth {\n    text-align: left;\n    border-top: solid 1px #fcdac2;\n    border-bottom: solid 1px #fcdac2;\n    background-color: #fcf1de;\n}\n\nth {\n    padding-left: 40px;\n    padding-top: 6px;\n    padding-bottom: 6px;\n}\n\ntd {\n    padding-left: 40px;\n    padding-top: 3px;\n    padding-bottom: 3px;\n}\n\nth:first-child, td:first-child {\n    padding-left: 5px;\n}\n\nth:last-child, td:last-child {\n    padding-right: 5px;\n}\n\ntr:nth-child(even) {\n    background-color: #fcf6eb;\n}\n\ntd.number, th.number, td.date, th.date {\n    text-align: right;\n}\n\naddress {\n    color: #999;\n    font-size: smaller;\n    margin-top: 6px;\n}\n\n</style>";
        private static final DateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm");

        DirectoryListingUtils() {
        }

        public static ByteBuffer createDirectoryListing(String requestPath, File baseDir, File directory) throws Exception {
            File[] files;
            StringBuffer sb = new StringBuffer();
            sb.append(HEADER_BOILERPLATE);
            String pathName = DirectoryListingUtils.getPathName(baseDir, directory);
            if ("".equals(pathName)) {
                pathName = "/";
            }
            sb.append(pathName);
            sb.append(BODY_BOILERPLATE);
            sb.append(pathName);
            sb.append(STYLE_BOILERPLATE);
            sb.append(TABLE_BOILERPLATE);
            if (!"/".equals(pathName)) {
                sb.append("<tr><td><a href=\"" + DirectoryListingUtils.getParentPath(requestPath) + "\">.. (Parent Directory)</a></td><td</td><td></td></tr>");
            }
            if ((files = DirectoryListingUtils.sortFiles(directory.listFiles())) != null) {
                for (File file : files) {
                    sb.append(DirectoryListingUtils.createDirectoryListRow(file));
                }
            }
            sb.append(FOOTER_BOILERPLATE);
            return ByteBuffer.wrap(sb.toString().getBytes());
        }

        private static File[] sortFiles(File[] unsortedFiles) {
            if (unsortedFiles == null || unsortedFiles.length == 0) {
                return null;
            }
            TreeMap<String, File> subDirMap = new TreeMap<String, File>();
            TreeMap<String, File> fileMap = new TreeMap<String, File>();
            for (File file : unsortedFiles) {
                if (file.isDirectory()) {
                    subDirMap.put(file.getName(), file);
                    continue;
                }
                fileMap.put(file.getName(), file);
            }
            int count = 0;
            File[] sortedFiles = new File[unsortedFiles.length];
            for (String key : subDirMap.keySet()) {
                sortedFiles[count++] = (File)subDirMap.get(key);
            }
            for (String key : fileMap.keySet()) {
                sortedFiles[count++] = (File)fileMap.get(key);
            }
            return sortedFiles;
        }

        private static String createDirectoryListRow(File file) {
            StringBuffer sb = new StringBuffer();
            if (file.isDirectory()) {
                sb.append("<tr><td><a href=\"" + file.getName() + "/\">" + file.getName() + "/</a>" + "</td><td></td><td class=\"date\">" + DirectoryListingUtils.getDateString(file.lastModified()) + "</td></tr>");
            } else {
                sb.append("<tr><td><a href=\"" + file.getName() + "\">" + file.getName() + "</a>" + "</td><td class=\"number\">" + DirectoryListingUtils.getFileSizeString(file.length()) + "</td><td class=\"date\">" + DirectoryListingUtils.getDateString(file.lastModified()) + "</td></tr>");
            }
            return sb.toString();
        }

        private static String getPathName(File baseDir, File targetFile) throws Exception {
            File baseDirCanonical;
            File canonicalFile = targetFile.getCanonicalFile();
            if (canonicalFile.equals(baseDirCanonical = baseDir.getCanonicalFile())) {
                return "";
            }
            return DirectoryListingUtils.getPathName(baseDirCanonical, canonicalFile.getParentFile()) + "/" + canonicalFile.getName();
        }

        private static String getParentPath(String path) {
            int lastSlashIndex;
            String parentPath = path;
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            if ((lastSlashIndex = parentPath.lastIndexOf("/")) != -1) {
                return parentPath.substring(0, lastSlashIndex + 1);
            }
            return parentPath;
        }

        private static String getFileSizeString(double fileSize) {
            int count = 0;
            while (fileSize > 1024.0) {
                fileSize /= 1024.0;
                ++count;
            }
            DecimalFormat format = new DecimalFormat("0.0");
            return format.format(fileSize) + SIZE_UNITS[count];
        }

        private static String getDateString(long timestamp) {
            return df.format(new Date(timestamp));
        }
    }
}

