/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.redirect;

import java.util.Properties;
import javax.annotation.Resource;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.http.redirect.HttpRedirectServiceHandler;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.util.feature.EarlyAccessFeatures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRedirectService
implements Service {
    private final Logger logger = LoggerFactory.getLogger((String)"service.directory");
    private HttpRedirectServiceHandler handler;
    private ServiceContext serviceContext;
    private Properties configuration;

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void init(ServiceContext serviceContext) throws Exception {
        EarlyAccessFeatures.HTTP_REDIRECT.assertEnabled(this.configuration, serviceContext.getLogger());
        this.serviceContext = serviceContext;
        this.handler = new HttpRedirectServiceHandler(this.logger);
        ServiceProperties properties = serviceContext.getProperties();
        String location = properties.get("location");
        if (location == null || "".equals(location)) {
            throw new IllegalArgumentException("Missing required property: location");
        }
        String strStatusCode = properties.get("status-code");
        HttpStatus statusCode = strStatusCode == null ? HttpStatus.REDIRECT_MULTIPLE_CHOICES : HttpStatus.getHttpStatus((String)strStatusCode);
        if (statusCode.code() > 399 || statusCode.code() < 300) {
            throw new IllegalArgumentException("Wrong value for status-code:" + statusCode + ". Valid values are integers between 300 and 399");
        }
        String cacheControlDirectives = properties.get("cache-control");
        this.handler.setLocation(location);
        this.handler.setStatusCode(statusCode);
        this.handler.setCacheControl(cacheControlDirectives);
    }

    public String getType() {
        return "http.redirect";
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        }
    }

    public void destroy() throws Exception {
    }

    public HttpRedirectServiceHandler getHandler() {
        return this.handler;
    }

    public void setHandler(HttpRedirectServiceHandler handler) {
        this.handler = handler;
    }
}

