/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.redirect;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.slf4j.Logger;

class HttpRedirectServiceHandler
extends IoHandlerAdapter<HttpAcceptSession> {
    private final Logger logger;
    private String location;
    private HttpStatus statusCode;
    private String cacheControl;
    private static final DateFormat RFC822_FORMAT_PATTERN = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);

    HttpRedirectServiceHandler(Logger logger) {
        this.logger = logger;
    }

    protected void doExceptionCaught(HttpAcceptSession session, Throwable cause) throws Exception {
        session.close(true);
    }

    protected void doSessionOpened(HttpAcceptSession session) throws Exception {
        session.setStatus(this.getStatusCode());
        session.setWriteHeader("Location", this.getLocation());
        if (this.getCacheControl() != null) {
            session.setWriteHeader("Cache-Control", this.getCacheControl());
            session.setWriteHeader("Expires", this.getExpiresHeader());
        }
        session.close(false);
    }

    private String getExpiresHeader() {
        return RFC822_FORMAT_PATTERN.format(new Date(0L));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpRedirectServiceHandler [");
        sb.append("location='").append(this.location).append("'");
        sb.append(", cache-control='").append(this.cacheControl).append("'");
        sb.append(", status-code=").append(this.statusCode);
        sb.append("]");
        return sb.toString();
    }

    String getLocation() {
        return this.location;
    }

    void setLocation(String location) {
        this.location = location;
    }

    HttpStatus getStatusCode() {
        return this.statusCode;
    }

    void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    String getCacheControl() {
        return this.cacheControl;
    }

    void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    static {
        RFC822_FORMAT_PATTERN.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

