/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.update.check;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GatewayVersion
implements Comparable<GatewayVersion> {
    private final int major;
    private final int minor;
    private final int patch;

    public GatewayVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object obj) {
        boolean result = !(obj instanceof GatewayVersion) ? false : (obj == this ? true : this.compareTo((GatewayVersion)obj) == 0);
        return result;
    }

    public static GatewayVersion parseGatewayVersion(String version) throws Exception {
        if ("develop-SNAPSHOT".equals(version)) {
            return new GatewayVersion(0, 0, 0);
        }
        String regex = "(?<major>[0-9]+)\\.(?<minor>[0-9]+)\\.(?<patch>[0-9]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("major"));
            int minor = Integer.parseInt(matcher.group("minor"));
            int patch = Integer.parseInt(matcher.group("patch"));
            return new GatewayVersion(major, minor, patch);
        }
        throw new IllegalArgumentException(String.format("version String is not of form %s", regex));
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(GatewayVersion o) {
        int result = this.major != o.major ? (this.major > o.major ? 1 : -1) : (this.minor != o.minor ? (this.minor > o.minor ? 1 : -1) : (this.patch != o.patch ? (this.patch > o.patch ? 1 : -1) : 0));
        return result;
    }
}

