/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.update.check;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.kaazing.gateway.server.impl.VersionUtils;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.update.check.GatewayVersion;
import org.kaazing.gateway.service.update.check.UpdateCheckListener;
import org.kaazing.gateway.service.update.check.UpdateCheckLoggingListener;
import org.kaazing.gateway.service.update.check.UpdateCheckTask;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;

public class UpdateCheckService
implements Service {
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledTasks;
    private GatewayVersion latestVersion;
    private final GatewayVersion currentVersion;
    private final String productName;
    private final String versionServiceUrl;
    private final Set<UpdateCheckListener> listeners = new HashSet<UpdateCheckListener>();
    private ServiceContext serviceContext;
    public static String MANAGEMENT_UPDATE_CHECK_LISTENER = "updateCheckListeners";

    public UpdateCheckService() {
        this.productName = VersionUtils.getGatewayProductTitle().replaceAll("\\s+", "");
        try {
            this.currentVersion = GatewayVersion.parseGatewayVersion(VersionUtils.getGatewayProductVersionPatch());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not locate a product version associated with the jars on the classpath", e);
        }
        this.versionServiceUrl = this.productName.toLowerCase().contains("enterprise") ? "https://version.kaazing.com" : "https://version.kaazing.org";
    }

    @Resource(name="schedulerProvider")
    public void setSchedulerProvider(SchedulerProvider provider) {
        this.scheduler = provider.getScheduler("update_check_service", false);
    }

    public String getType() {
        return "update check";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        this.serviceContext = serviceContext;
    }

    public void start() throws Exception {
        this.listeners.clear();
        this.addListener(new UpdateCheckLoggingListener());
        Map serviceSpecificObjects = this.serviceContext.getServiceSpecificObjects();
        Object managementListener = serviceSpecificObjects.get(MANAGEMENT_UPDATE_CHECK_LISTENER);
        if (managementListener != null && managementListener instanceof UpdateCheckListener) {
            this.addListener((UpdateCheckListener)managementListener);
        }
        for (UpdateCheckListener listener : this.listeners) {
            listener.setUpdateCheckService(this);
        }
        this.scheduledTasks = this.scheduler.scheduleAtFixedRate(new UpdateCheckTask(this, this.versionServiceUrl, this.productName), 0L, 7L, TimeUnit.DAYS);
    }

    public void stop() throws Exception {
        this.scheduledTasks.cancel(false);
    }

    public void quiesce() throws Exception {
        this.scheduledTasks.cancel(false);
    }

    public void destroy() throws Exception {
        this.scheduledTasks.cancel(true);
    }

    public void checkForUpdate(UpdateCheckListener updateCheckListener) {
        this.listeners.add(updateCheckListener);
        if (this.scheduler != null) {
            this.scheduler.schedule(new UpdateCheckTask(this, this.versionServiceUrl, this.productName), 0L, TimeUnit.SECONDS);
        } else {
            new UpdateCheckTask(this, this.versionServiceUrl, this.productName).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLatestGatewayVersion(GatewayVersion newlatestVersion) {
        if (this.latestVersion == null || this.latestVersion.compareTo(newlatestVersion) < 0) {
            UpdateCheckService updateCheckService = this;
            synchronized (updateCheckService) {
                this.latestVersion = newlatestVersion;
            }
            if (newlatestVersion.compareTo(this.currentVersion) > 0) {
                this.notifyListeners();
            }
        }
    }

    private synchronized GatewayVersion getLatestGatewayVersion() {
        return this.latestVersion;
    }

    private void notifyListeners() {
        for (UpdateCheckListener listener : this.listeners) {
            if (listener == null) continue;
            listener.newVersionAvailable(this.currentVersion, this.getLatestGatewayVersion());
        }
    }

    public void addListener(UpdateCheckListener newListener) {
        GatewayVersion latestGatewayVersion = this.getLatestGatewayVersion();
        if (latestGatewayVersion != null && latestGatewayVersion.compareTo(this.currentVersion) > 0) {
            newListener.newVersionAvailable(this.currentVersion, latestGatewayVersion);
        }
        newListener.setUpdateCheckService(this);
        this.listeners.add(newListener);
    }
}

