/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.update.check;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.kaazing.gateway.service.update.check.GatewayVersion;
import org.kaazing.gateway.service.update.check.UpdateCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UpdateCheckTask.class);
    private final UpdateCheckService updateCheckService;
    private final String protocolVersion = "1.0";
    private final String versionServiceUrl;

    public UpdateCheckTask(UpdateCheckService updateCheckService, String webServiceUrl, String productName) {
        this.updateCheckService = updateCheckService;
        this.versionServiceUrl = webServiceUrl.endsWith("/") ? String.format("%s%s/%s/latest", webServiceUrl, productName, "1.0") : String.format("%s/%s/%s/latest", webServiceUrl, productName, "1.0");
    }

    @Override
    public void run() {
        GatewayVersion latestVersion = this.fetchLatestVersion();
        if (latestVersion != null) {
            this.updateCheckService.setLatestGatewayVersion(latestVersion);
        }
    }

    private GatewayVersion fetchLatestVersion() {
        GatewayVersion latestVersion;
        block15: {
            latestVersion = null;
            String updateVersionUrl = this.getVersionServiceUrl();
            try {
                URL url = new URL(updateVersionUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Kaazing Update Service");
                connection.setRequestProperty("Connection", "close");
                connection.setRequestProperty("Accept", "text/plain");
                int responseCode = connection.getResponseCode();
                if (responseCode >= 200 && responseCode <= 300) {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
                        JSONTokener tokener = new JSONTokener((Reader)br);
                        JSONObject root = new JSONObject(tokener);
                        String version = root.getString("version");
                        latestVersion = GatewayVersion.parseGatewayVersion(version);
                        break block15;
                    }
                }
                throw new Exception(String.format("Unexpected %d response code from versioning service", responseCode));
            }
            catch (Exception e) {
                this.logger.warn(String.format("Update Check Service: Could not contact Kaazing versioning service at %s to find latest version of product: %s", updateVersionUrl, e));
            }
        }
        return latestVersion;
    }

    protected String getVersionServiceUrl() {
        return this.versionServiceUrl;
    }
}

