/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http;

import org.kaazing.gateway.transport.http.MutableHttpCookie;

public class DefaultHttpCookie
implements MutableHttpCookie,
Comparable<DefaultHttpCookie> {
    private final String name;
    private String comment;
    private String domain;
    private long maxAge;
    private String path;
    private boolean secure;
    private String value;
    private int version;

    public DefaultHttpCookie(String name, String domain, String path, String value) {
        this(name, domain, value);
        this.path = path;
    }

    public DefaultHttpCookie(String name, String domain, String value) {
        this(name, value);
        this.domain = domain;
    }

    public DefaultHttpCookie(String name, String value) {
        this(name);
        this.value = value;
    }

    public DefaultHttpCookie(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof DefaultHttpCookie)) {
            return false;
        }
        DefaultHttpCookie that = (DefaultHttpCookie)o;
        if (this.maxAge != that.maxAge) {
            return false;
        }
        if (this.secure != that.secure) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    @Override
    public int compareTo(DefaultHttpCookie that) {
        if (that == this) {
            return 0;
        }
        if (that == null || !(that instanceof DefaultHttpCookie)) {
            return Integer.MIN_VALUE;
        }
        int comparison = 0;
        if (comparison == 0) {
            comparison = (int)(that.maxAge - this.maxAge);
        }
        if (comparison == 0) {
            comparison = (that.secure ? 1 : 0) - (this.secure ? 1 : 0);
        }
        if (comparison == 0) {
            comparison = that.version - this.version;
        }
        if (comparison == 0) {
            int n = this.comment != null ? this.comment.compareTo(that.comment) : (comparison = that.comment == null ? 0 : Integer.MAX_VALUE);
        }
        if (comparison == 0) {
            int n = this.domain != null ? this.domain.compareTo(that.domain) : (comparison = that.domain == null ? 0 : Integer.MAX_VALUE);
        }
        if (comparison == 0) {
            int n = this.name != null ? this.name.compareTo(that.name) : (comparison = that.name == null ? 0 : Integer.MAX_VALUE);
        }
        if (comparison == 0) {
            int n = this.path != null ? this.path.compareTo(that.path) : (comparison = that.path == null ? 0 : Integer.MAX_VALUE);
        }
        if (comparison == 0) {
            comparison = this.value != null ? this.value.compareTo(that.value) : (that.value == null ? 0 : Integer.MAX_VALUE);
        }
        return comparison;
    }

    public String toString() {
        return "HTTP-COOKIE [name=" + this.name + ", domain=" + this.domain + ", path=" + this.path + ", maxAge=" + this.maxAge + ", secure=" + this.secure + ", version=" + this.version + ", value=" + this.value + "]";
    }
}

